/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.reader;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReaderIndex;
import oadd.org.apache.drill.exec.vector.accessor.reader.AbstractScalarReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.NullStateReaders;
import oadd.org.apache.drill.exec.vector.accessor.reader.OffsetVectorReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessor;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessors;

public abstract class BaseScalarReader
extends AbstractScalarReader {
    protected ColumnMetadata schema;
    protected VectorAccessor vectorAccessor;
    protected BufferAccessor bufferAccessor;

    public static AbstractScalarReader.ScalarObjectReader buildOptional(ColumnMetadata schema, VectorAccessor va, BaseScalarReader reader) {
        reader.bindVector(schema, VectorAccessors.nullableValuesAccessor(va));
        reader.bindNullState(new NullStateReaders.NullableIsSetVectorStateReader(va));
        return new AbstractScalarReader.ScalarObjectReader(reader);
    }

    public static AbstractScalarReader.ScalarObjectReader buildRequired(ColumnMetadata schema, VectorAccessor va, BaseScalarReader reader) {
        reader.bindVector(schema, va);
        reader.bindNullState(NullStateReaders.REQUIRED_STATE_READER);
        return new AbstractScalarReader.ScalarObjectReader(reader);
    }

    public void bindVector(ColumnMetadata schema, VectorAccessor va) {
        this.schema = schema;
        this.vectorAccessor = va;
        this.bufferAccessor = this.bufferAccessor(va);
    }

    protected BufferAccessor bufferAccessor(VectorAccessor va) {
        if (va.isHyper()) {
            return new HyperVectorBufferAccessor(va);
        }
        return new SingleVectorBufferAccessor(va);
    }

    @Override
    public void bindIndex(ColumnReaderIndex rowIndex) {
        super.bindIndex(rowIndex);
        this.vectorAccessor.bind(rowIndex);
    }

    @Override
    public ColumnMetadata schema() {
        return this.schema;
    }

    @Override
    public void bindBuffer() {
        this.bufferAccessor.rebind();
    }

    public final DrillBuf buffer() {
        return this.bufferAccessor.buffer();
    }

    private static class HyperVectorBufferAccessor
    implements BufferAccessor {
        private final VectorAccessor vectorAccessor;

        public HyperVectorBufferAccessor(VectorAccessor va) {
            this.vectorAccessor = va;
        }

        @Override
        public DrillBuf buffer() {
            BaseDataValueVector vector = (BaseDataValueVector)this.vectorAccessor.vector();
            return vector.getBuffer();
        }

        @Override
        public void rebind() {
        }
    }

    private static class SingleVectorBufferAccessor
    implements BufferAccessor {
        private final VectorAccessor va;
        private DrillBuf buffer;

        public SingleVectorBufferAccessor(VectorAccessor va) {
            this.va = va;
            this.rebind();
        }

        @Override
        public void rebind() {
            BaseDataValueVector vector = (BaseDataValueVector)this.va.vector();
            this.buffer = vector.getBuffer();
        }

        @Override
        public DrillBuf buffer() {
            return this.buffer;
        }
    }

    public static interface BufferAccessor {
        public DrillBuf buffer();

        public void rebind();
    }

    public static abstract class BaseVarWidthReader
    extends BaseScalarReader {
        protected OffsetVectorReader offsetsReader;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.offsetsReader = new OffsetVectorReader(VectorAccessors.varWidthOffsetVectorAccessor(va));
        }

        @Override
        public void bindIndex(ColumnReaderIndex index) {
            super.bindIndex(index);
            this.offsetsReader.bindIndex(index);
        }

        @Override
        public void bindBuffer() {
            super.bindBuffer();
            this.offsetsReader.bindBuffer();
        }

        public final long getEntry() {
            return this.offsetsReader.getEntry();
        }
    }

    public static abstract class BaseFixedWidthReader
    extends BaseScalarReader {
        public abstract int width();

        public final int offsetIndex() {
            return this.vectorIndex.offset();
        }
    }
}

