/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Set;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.VarCharHolder;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.Text;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VarCharVector;
import oadd.org.apache.drill.exec.vector.VarLenBulkEntry;
import oadd.org.apache.drill.exec.vector.VarLenBulkInput;
import oadd.org.apache.drill.exec.vector.VariableWidthVector;
import oadd.org.apache.drill.exec.vector.complex.impl.NullableVarCharReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;

public final class NullableVarCharVector
extends BaseDataValueVector
implements VariableWidthVector,
NullableVector {
    private static final int DEFINED_VALUES_ARRAY_LEN = 1024;
    private static final byte[] DEFINED_VALUES_ARRAY = new byte[1024];
    private final FieldReader reader = new NullableVarCharReaderImpl(this);
    private final UInt1Vector bits = new UInt1Vector(bitsField, this.allocator);
    private final VarCharVector values = new VarCharVector(this.field, this.allocator);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public NullableVarCharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.bits.getValueCapacity(), this.values.getValueCapacity());
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(false), this.values.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void close() {
        this.bits.close();
        this.values.close();
        super.close();
    }

    @Override
    public void clear() {
        this.bits.clear();
        this.values.clear();
        super.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.values.getBufferSizeFor(valueCount) + this.bits.getBufferSizeFor(valueCount);
    }

    @Override
    public int getAllocatedSize() {
        return this.bits.getAllocatedSize() + this.values.getAllocatedSize();
    }

    @Override
    public DrillBuf getBuffer() {
        return this.values.getBuffer();
    }

    @Override
    public VarCharVector getValuesVector() {
        return this.values;
    }

    @Override
    public UInt1Vector getBitsVector() {
        return this.bits;
    }

    @Override
    public UInt4Vector getOffsetVector() {
        return this.values.getOffsetVector();
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.bits.setInitialCapacity(numRecords);
        this.values.setInitialCapacity(numRecords);
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            success = this.values.allocateNewSafe() && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
                return false;
            }
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return success;
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.bits.collectLedgers(ledgers);
        this.values.collectLedgers(ledgers);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return this.bits.getPayloadByteCount(valueCount) + this.values.getPayloadByteCount(valueCount);
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount) {
        try {
            this.values.allocateNew(totalBytes, valueCount);
            this.bits.allocateNew(valueCount);
        }
        catch (RuntimeException e) {
            this.clear();
            throw e;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public void reset() {
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        super.reset();
    }

    @Override
    public int getByteCapacity() {
        return this.values.getByteCapacity();
    }

    @Override
    public int getCurrentSizeInBytes() {
        return this.values.getCurrentSizeInBytes();
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        this.bits.load(bitsField, buffer);
        int capacity = buffer.capacity();
        int bitsLength = bitsField.getBufferLength();
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.values.load(valuesField, buffer.slice(bitsLength, capacity - bitsLength));
        this.mutator.lastSet = this.accessor.getValueCount() - 1;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableVarCharVector)to);
    }

    public void transferTo(NullableVarCharVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        target.mutator.lastSet = this.mutator.lastSet;
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, NullableVarCharVector target) {
        this.bits.splitAndTransferTo(startIndex, length, target.bits);
        this.values.splitAndTransferTo(startIndex, length, target.values);
        target.mutator.lastSet = length - 1;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public VarCharVector convertToRequiredVector() {
        VarCharVector v = new VarCharVector(this.getField().getOtherNullableVersion(), this.allocator);
        if (v.data != null) {
            v.data.release(1);
        }
        v.data = this.values.data;
        v.data.retain(1);
        this.clear();
        return v;
    }

    public int getBitsValueCapacity() {
        return this.bits.getValueCapacity();
    }

    public void copyFrom(int fromIndex, int thisIndex, NullableVarCharVector from) {
        Accessor fromAccessor = from.getAccessor();
        if (!fromAccessor.isNull(fromIndex)) {
            this.mutator.set(thisIndex, fromAccessor.get(fromIndex));
        }
    }

    public void copyFromSafe(int fromIndex, int thisIndex, VarCharVector from) {
        this.mutator.fillEmpties(thisIndex);
        this.values.copyFromSafe(fromIndex, thisIndex, from);
        this.bits.getMutator().setSafe(thisIndex, 1);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, NullableVarCharVector from) {
        this.mutator.fillEmpties(thisIndex);
        this.bits.copyFromSafe(fromIndex, thisIndex, from.bits);
        this.values.copyFromSafe(fromIndex, thisIndex, from.values);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.mutator.fillEmpties(toIndex);
        if (from instanceof VarCharVector) {
            this.bits.getMutator().setSafe(toIndex, 1);
            this.values.copyFromSafe(fromIndex, toIndex, (VarCharVector)from);
            return;
        }
        NullableVarCharVector fromVector = (NullableVarCharVector)from;
        this.bits.copyFromSafe(fromIndex, toIndex, fromVector.bits);
        this.values.copyFromSafe(fromIndex, toIndex, fromVector.values);
    }

    @Override
    public void exchange(ValueVector other) {
        NullableVarCharVector target = (NullableVarCharVector)other;
        this.bits.exchange(target.bits);
        this.values.exchange(target.values);
        this.mutator.exchange(other.getMutator());
    }

    static {
        Arrays.fill(DEFINED_VALUES_ARRAY, (byte)1);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements NullableVectorDefinitionSetter,
    VariableWidthVector.VariableWidthMutator,
    NullableVector.Mutator {
        private int lastSet = -1;

        private Mutator() {
        }

        public VarCharVector getVectorWithValues() {
            return NullableVarCharVector.this.values;
        }

        @Override
        public void setIndexDefined(int index) {
            NullableVarCharVector.this.bits.getMutator().set(index, 1);
        }

        @Override
        public void setIndexDefined(int index, int numValues) {
            int batchSz;
            for (int remaining = numValues; remaining > 0; remaining -= batchSz) {
                batchSz = Math.min(remaining, 1024);
                NullableVarCharVector.this.bits.getMutator().set(index + (numValues - remaining), DEFINED_VALUES_ARRAY, 0, batchSz);
            }
        }

        public void set(int index, byte[] value) {
            VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
            UInt1Vector.Mutator bitsMutator = NullableVarCharVector.this.bits.getMutator();
            valuesMutator.fillEmpties(this.lastSet, index);
            bitsMutator.set(index, 1);
            valuesMutator.set(index, value);
            this.lastSet = index;
        }

        @VisibleForTesting
        protected void fillEmpties(int index) {
            NullableVarCharVector.this.values.getMutator().fillEmpties(this.lastSet, index);
            while (index > NullableVarCharVector.this.bits.getValueCapacity()) {
                NullableVarCharVector.this.bits.reAlloc();
            }
            this.lastSet = index;
        }

        @Override
        public void setValueLengthSafe(int index, int length) {
            NullableVarCharVector.this.values.getMutator().setValueLengthSafe(index, length);
            this.lastSet = index;
        }

        public void setSafe(int index, byte[] value, int start, int length) {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.bits.getMutator().setSafe(index, 1);
            NullableVarCharVector.this.values.getMutator().setSafe(index, value, start, length);
            this.lastSet = index;
        }

        public void setSafe(int index, ByteBuffer value, int start, int length) {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.bits.getMutator().setSafe(index, 1);
            NullableVarCharVector.this.values.getMutator().setSafe(index, value, start, length);
            this.lastSet = index;
        }

        public void setNull(int index) {
            NullableVarCharVector.this.bits.getMutator().setSafe(index, 0);
        }

        public void setSkipNull(int index, VarCharHolder holder) {
            NullableVarCharVector.this.values.getMutator().set(index, holder);
        }

        public void setSkipNull(int index, NullableVarCharHolder holder) {
            NullableVarCharVector.this.values.getMutator().set(index, holder);
        }

        public void set(int index, NullableVarCharHolder holder) {
            VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
            valuesMutator.fillEmpties(this.lastSet, index);
            NullableVarCharVector.this.bits.getMutator().set(index, holder.isSet);
            valuesMutator.set(index, holder);
            this.lastSet = index;
        }

        public void set(int index, VarCharHolder holder) {
            VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
            valuesMutator.fillEmpties(this.lastSet, index);
            NullableVarCharVector.this.bits.getMutator().set(index, 1);
            valuesMutator.set(index, holder);
            this.lastSet = index;
        }

        public boolean isSafe(int outIndex) {
            return outIndex < NullableVarCharVector.this.getValueCapacity();
        }

        public void set(int index, int isSet, int startField, int endField, DrillBuf bufferField) {
            VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
            valuesMutator.fillEmpties(this.lastSet, index);
            NullableVarCharVector.this.bits.getMutator().set(index, isSet);
            valuesMutator.set(index, startField, endField, bufferField);
            this.lastSet = index;
        }

        public void setSafe(int index, int isSet, int startField, int endField, DrillBuf bufferField) {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.bits.getMutator().setSafe(index, isSet);
            NullableVarCharVector.this.values.getMutator().setSafe(index, startField, endField, bufferField);
            this.lastSet = index;
        }

        public void setSafe(int index, NullableVarCharHolder value) {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.bits.getMutator().setSafe(index, value.isSet);
            NullableVarCharVector.this.values.getMutator().setSafe(index, value);
            this.lastSet = index;
        }

        public void setSafe(int index, VarCharHolder value) {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.bits.getMutator().setSafe(index, 1);
            NullableVarCharVector.this.values.getMutator().setSafe(index, value);
            this.lastSet = index;
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            this.fillEmpties(valueCount);
            this.lastSet = valueCount - 1;
            NullableVarCharVector.this.values.getMutator().setValueCount(valueCount);
            NullableVarCharVector.this.bits.getMutator().setValueCount(valueCount);
        }

        public void setSafe(VarLenBulkInput<VarLenBulkEntry> input) {
            VarLenBulkInputCallbackImpl callback = new VarLenBulkInputCallbackImpl(input.getStartIndex());
            NullableVarCharVector.this.values.getMutator().setSafe(input, callback);
        }

        @Override
        public void generateTestData(int valueCount) {
            NullableVarCharVector.this.bits.getMutator().generateTestDataAlt(valueCount);
            NullableVarCharVector.this.values.getMutator().generateTestData(valueCount);
            this.lastSet = valueCount;
            this.setValueCount(valueCount);
        }

        @Override
        public void reset() {
            this.lastSet = -1;
        }

        @VisibleForTesting
        public int getLastSet() {
            return this.lastSet;
        }

        @Override
        public void setSetCount(int n) {
            this.lastSet = n - 1;
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
            Mutator target = (Mutator)other;
            int temp = this.lastSet;
            this.lastSet = target.lastSet;
            target.lastSet = temp;
        }

        public void fromNotNullable(VarCharVector srce) {
            NullableVarCharVector.this.clear();
            int valueCount = srce.getAccessor().getValueCount();
            BaseValueVector.fillBitsVector(NullableVarCharVector.this.getBitsVector(), valueCount);
            NullableVarCharVector.this.getValuesVector().exchange(srce);
            this.lastSet = valueCount;
            this.setValueCount(valueCount);
        }

        private final class VarLenBulkInputCallbackImpl
        implements VarLenBulkInput.BulkInputCallback<VarLenBulkEntry> {
            private static final int DEFAULT_BUFF_SZ = 4096;
            private final UInt1Vector.BufferedMutator bitsMutator;

            private VarLenBulkInputCallbackImpl(int _start_idx) {
                this.bitsMutator = new UInt1Vector.BufferedMutator(_start_idx, 4096, NullableVarCharVector.this.bits);
            }

            @Override
            public void onNewBulkEntry(VarLenBulkEntry entry) {
                int toCopy;
                int[] lengths = entry.getValuesLength();
                ByteBuffer buffer = this.bitsMutator.getByteBuffer();
                byte[] bufferArray = buffer.array();
                int remaining = entry.getNumValues();
                int srcPos = 0;
                do {
                    int idx;
                    if (buffer.remaining() < 1) {
                        this.bitsMutator.flush();
                    }
                    toCopy = Math.min(remaining, buffer.remaining());
                    int startTgtPos = buffer.position();
                    int maxTgtPos = startTgtPos + toCopy;
                    if (entry.hasNulls()) {
                        for (idx = startTgtPos; idx < maxTgtPos; ++idx) {
                            int valLen;
                            bufferArray[idx] = (valLen = lengths[srcPos++]) >= 0 ? (byte)1 : 0;
                        }
                    } else {
                        for (idx = startTgtPos; idx < maxTgtPos; ++idx) {
                            bufferArray[idx] = 1;
                        }
                    }
                    buffer.position(maxTgtPos);
                } while ((remaining -= toCopy) > 0);
                Mutator.this.lastSet = Mutator.this.lastSet + entry.getNumValues();
            }

            @Override
            public void onEndBulkInput() {
                this.bitsMutator.flush();
            }
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor
    implements VariableWidthVector.VariableWidthAccessor {
        final UInt1Vector.Accessor bAccessor;
        final VarCharVector.Accessor vAccessor;

        public Accessor() {
            this.bAccessor = NullableVarCharVector.this.bits.getAccessor();
            this.vAccessor = NullableVarCharVector.this.values.getAccessor();
        }

        public byte[] get(int index) {
            if (this.isNull(index)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public long getStartEnd(int index) {
            return this.vAccessor.getStartEnd(index);
        }

        @Override
        public int getValueLength(int index) {
            return NullableVarCharVector.this.values.getAccessor().getValueLength(index);
        }

        public void get(int index, NullableVarCharHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        @Override
        public Text getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        @Override
        public int getValueCount() {
            return NullableVarCharVector.this.bits.getAccessor().getValueCount();
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        private final NullableVarCharVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new NullableVarCharVector(field, allocator);
        }

        public TransferImpl(NullableVarCharVector to) {
            this.to = to;
        }

        @Override
        public NullableVarCharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableVarCharVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            NullableVarCharVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, NullableVarCharVector.this);
        }
    }
}

