/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.util.Arrays;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class ArrayWrappedIntIntMap {
    private static final int MAX_KEY_VALUE = 32768;
    private static final int INITIAL_MAX_KEY_VALUE = 128;
    private int[] values = new int[129];

    public ArrayWrappedIntIntMap() {
        Arrays.fill(this.values, Integer.MIN_VALUE);
    }

    public void put(int key, int value) {
        Preconditions.checkArgument(key >= 0 && key <= 32768, String.format("Index should be in range [0, %d], given [%d].", 32768, key));
        Preconditions.checkArgument(value >= 0, String.format("Value must be non-negative, given [%d]", value));
        if (this.values.length < key + 1) {
            int newValuesLength = Integer.highestOneBit(key) * 2;
            int[] newValues = Arrays.copyOf(this.values, newValuesLength);
            Arrays.fill(newValues, this.values.length, newValues.length - 1, Integer.MIN_VALUE);
            this.values = newValues;
        }
        this.values[key] = value;
    }

    public int get(int key) {
        return this.values[key];
    }
}

