/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.config.LogicalPlanPersistence;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;
import oadd.org.apache.drill.exec.compile.CodeCompiler;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import oadd.org.apache.drill.exec.expr.fn.registry.RemoteFunctionRegistry;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import oadd.org.apache.drill.exec.planner.PhysicalPlanReader;
import oadd.org.apache.drill.exec.planner.sql.DrillOperatorTable;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.rpc.control.Controller;
import oadd.org.apache.drill.exec.rpc.control.WorkEventBus;
import oadd.org.apache.drill.exec.rpc.data.DataConnectionCreator;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorProvider;
import oadd.org.apache.drill.exec.rpc.user.UserServer;
import oadd.org.apache.drill.exec.server.BootStrapContext;
import oadd.org.apache.drill.exec.server.QueryProfileStoreContext;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.OptionSet;
import oadd.org.apache.drill.exec.server.options.SystemOptionManager;
import oadd.org.apache.drill.exec.store.SchemaFactory;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.store.sys.PersistentStoreProvider;
import oadd.org.apache.drill.exec.work.foreman.rm.ResourceManager;
import oadd.org.apache.drill.exec.work.foreman.rm.ResourceManagerBuilder;
import org.apache.drill.metastore.MetastoreRegistry;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class DrillbitContext
implements AutoCloseable {
    private final BootStrapContext context;
    private final PhysicalPlanReader reader;
    private final ClusterCoordinator coord;
    private final DataConnectionCreator connectionsPool;
    private final CoordinationProtos.DrillbitEndpoint endpoint;
    private final StoragePluginRegistry storagePlugins;
    private final OperatorCreatorRegistry operatorCreatorRegistry;
    private final Controller controller;
    private final WorkEventBus workBus;
    private final FunctionImplementationRegistry functionRegistry;
    private final SystemOptionManager systemOptions;
    private final PersistentStoreProvider provider;
    private final CodeCompiler compiler;
    private final ScanResult classpathScan;
    private final LogicalPlanPersistence lpPersistence;
    private final DrillOperatorTable table;
    private final QueryProfileStoreContext profileStoreContext;
    private ResourceManager resourceManager;
    private final MetastoreRegistry metastoreRegistry;

    public DrillbitContext(CoordinationProtos.DrillbitEndpoint endpoint, BootStrapContext context, ClusterCoordinator coord, Controller controller, DataConnectionCreator connectionsPool, WorkEventBus workBus, PersistentStoreProvider provider) {
        this(endpoint, context, coord, controller, connectionsPool, workBus, provider, provider);
    }

    public DrillbitContext(CoordinationProtos.DrillbitEndpoint endpoint, BootStrapContext context, ClusterCoordinator coord, Controller controller, DataConnectionCreator connectionsPool, WorkEventBus workBus, PersistentStoreProvider provider, PersistentStoreProvider profileStoreProvider) {
        this.classpathScan = context.getClasspathScan();
        this.workBus = workBus;
        this.controller = Preconditions.checkNotNull(controller);
        this.context = Preconditions.checkNotNull(context);
        this.coord = coord;
        this.connectionsPool = Preconditions.checkNotNull(connectionsPool);
        this.endpoint = Preconditions.checkNotNull(endpoint);
        this.provider = provider;
        DrillConfig config = context.getConfig();
        this.lpPersistence = new LogicalPlanPersistence(config, this.classpathScan);
        this.storagePlugins = config.getInstance("drill.exec.storage.registry", StoragePluginRegistry.class, this);
        this.reader = new PhysicalPlanReader(config, this.classpathScan, this.lpPersistence, endpoint, this.storagePlugins);
        this.operatorCreatorRegistry = new OperatorCreatorRegistry(this.classpathScan);
        this.systemOptions = new SystemOptionManager(this.lpPersistence, provider, config, context.getDefinitions());
        this.functionRegistry = new FunctionImplementationRegistry(config, this.classpathScan, (OptionManager)this.systemOptions);
        this.compiler = new CodeCompiler(config, (OptionSet)this.systemOptions);
        this.table = new DrillOperatorTable(this.functionRegistry, (OptionManager)this.systemOptions);
        this.profileStoreContext = new QueryProfileStoreContext(config, profileStoreProvider, coord);
        this.metastoreRegistry = new MetastoreRegistry(config);
    }

    public QueryProfileStoreContext getProfileStoreContext() {
        return this.profileStoreContext;
    }

    public void startRM() {
        this.resourceManager = new ResourceManagerBuilder(this).build();
    }

    public FunctionImplementationRegistry getFunctionImplementationRegistry() {
        return this.functionRegistry;
    }

    public WorkEventBus getWorkBus() {
        return this.workBus;
    }

    public SystemOptionManager getOptionManager() {
        return this.systemOptions;
    }

    public CoordinationProtos.DrillbitEndpoint getEndpoint() {
        return this.endpoint;
    }

    public DrillConfig getConfig() {
        return this.context.getConfig();
    }

    public Collection<CoordinationProtos.DrillbitEndpoint> getAvailableBits() {
        return this.coord.getAvailableEndpoints();
    }

    public Collection<CoordinationProtos.DrillbitEndpoint> getBits() {
        return this.coord.getOnlineEndPoints();
    }

    public boolean isOnline(CoordinationProtos.DrillbitEndpoint endpoint) {
        return endpoint.getState().equals(CoordinationProtos.DrillbitEndpoint.State.ONLINE);
    }

    public boolean isForeman(CoordinationProtos.DrillbitEndpoint endpoint) {
        CoordinationProtos.DrillbitEndpoint foreman = this.getEndpoint();
        return endpoint.getAddress().equals(foreman.getAddress()) && endpoint.getUserPort() == foreman.getUserPort();
    }

    public boolean isForemanOnline() {
        Collection<CoordinationProtos.DrillbitEndpoint> dbs = this.getAvailableBits();
        for (CoordinationProtos.DrillbitEndpoint db : dbs) {
            if (!this.isForeman(db) || !this.isOnline(db)) continue;
            return true;
        }
        return false;
    }

    public BufferAllocator getAllocator() {
        return this.context.getAllocator();
    }

    public OperatorCreatorRegistry getOperatorCreatorRegistry() {
        return this.operatorCreatorRegistry;
    }

    public StoragePluginRegistry getStorage() {
        return this.storagePlugins;
    }

    public EventLoopGroup getBitLoopGroup() {
        return this.context.getBitLoopGroup();
    }

    public DataConnectionCreator getDataConnectionsPool() {
        return this.connectionsPool;
    }

    public Controller getController() {
        return this.controller;
    }

    public MetricRegistry getMetrics() {
        return this.context.getMetrics();
    }

    public PhysicalPlanReader getPlanReader() {
        return this.reader;
    }

    public PersistentStoreProvider getStoreProvider() {
        return this.provider;
    }

    public SchemaFactory getSchemaFactory() {
        return this.storagePlugins.getSchemaFactory();
    }

    public ClusterCoordinator getClusterCoordinator() {
        return this.coord;
    }

    public CodeCompiler getCompiler() {
        return this.compiler;
    }

    public ExecutorService getExecutor() {
        return this.context.getExecutor();
    }

    public ExecutorService getScanExecutor() {
        return this.context.getScanExecutor();
    }

    public ExecutorService getScanDecodeExecutor() {
        return this.context.getScanDecodeExecutor();
    }

    public LogicalPlanPersistence getLpPersistence() {
        return this.lpPersistence;
    }

    public ScanResult getClasspathScan() {
        return this.classpathScan;
    }

    public RemoteFunctionRegistry getRemoteFunctionRegistry() {
        return this.functionRegistry.getRemoteFunctionRegistry();
    }

    public DrillOperatorTable getOperatorTable() {
        return this.table;
    }

    public AuthenticatorProvider getAuthProvider() {
        return this.context.getAuthProvider();
    }

    public Set<Map.Entry<UserServer.BitToUserConnection, UserServer.BitToUserConnectionConfig>> getUserConnections() {
        return UserServer.getUserConnections();
    }

    @Override
    public void close() throws Exception {
        this.getOptionManager().close();
        this.getFunctionImplementationRegistry().close();
        this.getRemoteFunctionRegistry().close();
        this.getCompiler().close();
        this.getMetastoreRegistry().close();
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public MetastoreRegistry getMetastoreRegistry() {
        return this.metastoreRegistry;
    }
}

