/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.security;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.EnumMap;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import oadd.com.google.protobuf.ByteString;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.InvalidProtocolBufferException;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufInputStream;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.rpc.RequestHandler;
import oadd.org.apache.drill.exec.rpc.Response;
import oadd.org.apache.drill.exec.rpc.ResponseSender;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.ServerConnection;
import oadd.org.apache.drill.exec.rpc.security.SaslProperties;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAuthenticationHandler<S extends ServerConnection<S>, T extends Internal.EnumLite>
implements RequestHandler<S> {
    private static final Logger logger = LoggerFactory.getLogger(ServerAuthenticationHandler.class);
    private static final ImmutableMap<UserBitShared.SaslStatus, SaslResponseProcessor> RESPONSE_PROCESSORS;
    private final RequestHandler<S> requestHandler;
    private final int saslRequestTypeValue;
    private final T saslResponseType;
    private static final UserBitShared.SaslMessage SASL_FAILED_MESSAGE;

    public ServerAuthenticationHandler(RequestHandler<S> requestHandler, int saslRequestTypeValue, T saslResponseType) {
        this.requestHandler = requestHandler;
        this.saslRequestTypeValue = saslRequestTypeValue;
        this.saslResponseType = saslResponseType;
    }

    @Override
    public void handle(S connection, int rpcType, ByteBuf pBody, ByteBuf dBody, ResponseSender sender) throws RpcException {
        String remoteAddress = connection.getRemoteAddress().toString();
        if (this.saslRequestTypeValue == rpcType) {
            UserBitShared.SaslMessage saslResponse;
            try {
                saslResponse = UserBitShared.SaslMessage.PARSER.parseFrom(new ByteBufInputStream(pBody));
            }
            catch (InvalidProtocolBufferException e) {
                ServerAuthenticationHandler.handleAuthFailure(connection, sender, e, this.saslResponseType);
                return;
            }
            logger.trace("Received SASL message {} from {}", (Object)saslResponse.getStatus(), (Object)remoteAddress);
            SaslResponseProcessor processor = RESPONSE_PROCESSORS.get(saslResponse.getStatus());
            if (processor == null) {
                logger.info("Unknown message type from client from {}. Will stop authentication.", (Object)remoteAddress);
                ServerAuthenticationHandler.handleAuthFailure(connection, sender, new SaslException("Received unexpected message"), this.saslResponseType);
                return;
            }
            SaslResponseContext<S, T> context = new SaslResponseContext<S, T>(saslResponse, connection, sender, this.requestHandler, this.saslResponseType);
            try {
                processor.process(context);
            }
            catch (Exception e) {
                ServerAuthenticationHandler.handleAuthFailure(connection, sender, e, this.saslResponseType);
            }
        } else {
            throw new RpcException(String.format("Request of type %d is not allowed without authentication. Client on %s must authenticate before making requests. Connection dropped. [Details: %s]", rpcType, remoteAddress, connection.getEncryptionCtxtString()));
        }
    }

    private static byte[] evaluateResponse(final SaslServer saslServer, final byte[] responseBytes) throws SaslException {
        try {
            return UserGroupInformation.getLoginUser().doAs(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return saslServer.evaluateResponse(responseBytes);
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw new SaslException(String.format("Unexpected failure trying to authenticate using %s", saslServer.getMechanismName()), e.getCause());
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof SaslException) {
                throw (SaslException)e;
            }
            throw new SaslException(String.format("Unexpected failure trying to authenticate using %s", saslServer.getMechanismName()), e);
        }
    }

    private static <S extends ServerConnection<S>, T extends Internal.EnumLite> void handleSuccess(SaslResponseContext<S, T> context, UserBitShared.SaslMessage.Builder challenge, SaslServer saslServer) throws IOException {
        Object connection = context.connection;
        connection.changeHandlerTo(context.requestHandler);
        connection.finalizeSaslSession();
        try {
            String expectedQOP;
            String negotiatedQOP = saslServer.getNegotiatedProperty("javax.security.sasl.qop").toString();
            String string = expectedQOP = connection.isEncryptionEnabled() ? SaslProperties.QualityOfProtection.PRIVACY.getSaslQop() : SaslProperties.QualityOfProtection.AUTHENTICATION.getSaslQop();
            if (!negotiatedQOP.equals(expectedQOP)) {
                throw new SaslException(String.format("Mismatch in negotiated QOP value: %s and Expected QOP value: %s", negotiatedQOP, expectedQOP));
            }
            if (connection.isEncryptionEnabled()) {
                int negotiatedRawSendSize = Integer.parseInt(saslServer.getNegotiatedProperty("javax.security.sasl.rawsendsize").toString());
                if (negotiatedRawSendSize <= 0) {
                    throw new SaslException(String.format("Negotiated rawSendSize: %d is invalid. Please check the configured value of encryption.sasl.max_wrapped_size. It might be configured to a very small value.", negotiatedRawSendSize));
                }
                connection.setWrapSizeLimit(negotiatedRawSendSize);
            }
        }
        catch (IllegalStateException | NumberFormatException e) {
            throw new SaslException(String.format("Unexpected failure while retrieving negotiated property values (%s)", e.getMessage()), e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Authenticated {} successfully using {} from {} with encryption context {}", saslServer.getAuthorizationID(), saslServer.getMechanismName(), connection.getRemoteAddress().toString(), connection.getEncryptionCtxtString());
        }
        context.sender.send(new Response((Internal.EnumLite)context.saslResponseType, challenge.build(), new ByteBuf[0]));
        if (connection.isEncryptionEnabled()) {
            connection.addSecurityHandlers();
        } else {
            connection.disposeSaslServer();
        }
    }

    private static <S extends ServerConnection<S>, T extends Internal.EnumLite> void handleAuthFailure(S connection, ResponseSender sender, Exception e, T saslResponseType) throws RpcException {
        String remoteAddress = connection.getRemoteAddress().toString();
        logger.debug("Authentication using mechanism {} with encryption context {} failed from client {} due to {}", connection.getSaslServer().getMechanismName(), connection.getEncryptionCtxtString(), remoteAddress, e);
        sender.send(new Response(saslResponseType, SASL_FAILED_MESSAGE, new ByteBuf[0]));
        throw new RpcException(e);
    }

    static {
        EnumMap<UserBitShared.SaslStatus, SaslResponseProcessor> map = new EnumMap<UserBitShared.SaslStatus, SaslResponseProcessor>(UserBitShared.SaslStatus.class);
        map.put(UserBitShared.SaslStatus.SASL_START, new SaslStartProcessor());
        map.put(UserBitShared.SaslStatus.SASL_IN_PROGRESS, new SaslInProgressProcessor());
        map.put(UserBitShared.SaslStatus.SASL_SUCCESS, new SaslSuccessProcessor());
        map.put(UserBitShared.SaslStatus.SASL_FAILED, new SaslFailedProcessor());
        RESPONSE_PROCESSORS = Maps.immutableEnumMap(map);
        SASL_FAILED_MESSAGE = UserBitShared.SaslMessage.newBuilder().setStatus(UserBitShared.SaslStatus.SASL_FAILED).build();
    }

    private static class SaslFailedProcessor
    implements SaslResponseProcessor {
        private SaslFailedProcessor() {
        }

        @Override
        public <S extends ServerConnection<S>, T extends Internal.EnumLite> void process(SaslResponseContext<S, T> context) throws Exception {
            Object connection = context.connection;
            logger.info("Client from {} failed authentication with encryption context:{} graciously, and does not want to continue.", (Object)connection.getRemoteAddress().toString(), (Object)connection.getEncryptionCtxtString());
            throw new SaslException(String.format("Client graciously failed authentication. [Details: %s]", connection.getEncryptionCtxtString()));
        }
    }

    private static class SaslSuccessProcessor
    implements SaslResponseProcessor {
        private SaslSuccessProcessor() {
        }

        @Override
        public <S extends ServerConnection<S>, T extends Internal.EnumLite> void process(SaslResponseContext<S, T> context) throws Exception {
            SaslServer saslServer = context.connection.getSaslServer();
            ServerAuthenticationHandler.evaluateResponse(saslServer, context.saslResponse.getData().toByteArray());
            if (!saslServer.isComplete()) {
                Object connection = context.connection;
                logger.info("Failed to authenticate client from {} with encryption context:{}", (Object)connection.getRemoteAddress().toString(), (Object)connection.getEncryptionCtxtString());
                throw new SaslException(String.format("Client allegedly succeeded authentication but server did not. Suspicious? [Details: %s]", connection.getEncryptionCtxtString()));
            }
            UserBitShared.SaslMessage.Builder challenge = UserBitShared.SaslMessage.newBuilder();
            challenge.setStatus(UserBitShared.SaslStatus.SASL_SUCCESS);
            ServerAuthenticationHandler.handleSuccess(context, challenge, saslServer);
        }
    }

    private static class SaslInProgressProcessor
    implements SaslResponseProcessor {
        private SaslInProgressProcessor() {
        }

        @Override
        public <S extends ServerConnection<S>, T extends Internal.EnumLite> void process(SaslResponseContext<S, T> context) throws Exception {
            UserBitShared.SaslMessage.Builder challenge = UserBitShared.SaslMessage.newBuilder();
            SaslServer saslServer = context.connection.getSaslServer();
            byte[] challengeBytes = ServerAuthenticationHandler.evaluateResponse(saslServer, context.saslResponse.getData().toByteArray());
            if (saslServer.isComplete()) {
                challenge.setStatus(UserBitShared.SaslStatus.SASL_SUCCESS);
                if (challengeBytes != null) {
                    challenge.setData(ByteString.copyFrom(challengeBytes));
                }
                ServerAuthenticationHandler.handleSuccess(context, challenge, saslServer);
            } else {
                challenge.setStatus(UserBitShared.SaslStatus.SASL_IN_PROGRESS).setData(ByteString.copyFrom(challengeBytes));
                context.sender.send(new Response((Internal.EnumLite)context.saslResponseType, challenge.build(), new ByteBuf[0]));
            }
        }
    }

    private static class SaslStartProcessor
    implements SaslResponseProcessor {
        private SaslStartProcessor() {
        }

        @Override
        public <S extends ServerConnection<S>, T extends Internal.EnumLite> void process(SaslResponseContext<S, T> context) throws Exception {
            context.connection.initSaslServer(context.saslResponse.getMechanism());
            ((SaslResponseProcessor)RESPONSE_PROCESSORS.get(UserBitShared.SaslStatus.SASL_IN_PROGRESS)).process(context);
        }
    }

    private static interface SaslResponseProcessor {
        public <S extends ServerConnection<S>, T extends Internal.EnumLite> void process(SaslResponseContext<S, T> var1) throws Exception;
    }

    private static class SaslResponseContext<S extends ServerConnection<S>, T extends Internal.EnumLite> {
        final UserBitShared.SaslMessage saslResponse;
        final S connection;
        final ResponseSender sender;
        final RequestHandler<S> requestHandler;
        final T saslResponseType;

        SaslResponseContext(UserBitShared.SaslMessage saslResponse, S connection, ResponseSender sender, RequestHandler<S> requestHandler, T saslResponseType) {
            this.saslResponse = Preconditions.checkNotNull(saslResponse);
            this.connection = (ServerConnection)Preconditions.checkNotNull(connection);
            this.sender = Preconditions.checkNotNull(sender);
            this.requestHandler = Preconditions.checkNotNull(requestHandler);
            this.saslResponseType = (Internal.EnumLite)Preconditions.checkNotNull(saslResponseType);
        }
    }
}

