/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.security;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableCollection;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastSaslClientFactory
implements SaslClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(FastSaslClientFactory.class);
    private ImmutableMap<String, List<SaslClientFactory>> clientFactories;

    public static FastSaslClientFactory getInstance() {
        return Holder.INSTANCE;
    }

    @VisibleForTesting
    static void reload() {
        FastSaslClientFactory.getInstance().refresh();
    }

    private FastSaslClientFactory() {
        this.refresh();
    }

    private void refresh() {
        Enumeration<SaslClientFactory> factories = Sasl.getSaslClientFactories();
        HashMap map = Maps.newHashMap();
        while (factories.hasMoreElements()) {
            SaslClientFactory factory = factories.nextElement();
            for (String mechanismName : factory.getMechanismNames(null)) {
                if (!map.containsKey(mechanismName)) {
                    map.put(mechanismName, new ArrayList());
                }
                ((List)map.get(mechanismName)).add(factory);
            }
        }
        this.clientFactories = ImmutableMap.copyOf(map);
        if (logger.isDebugEnabled()) {
            logger.debug("Registered sasl client factories: {}", (Object)this.clientFactories.keySet());
        }
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (String mechanism : mechanisms) {
            List<SaslClientFactory> factories = this.clientFactories.get(mechanism);
            if (factories == null) continue;
            for (SaslClientFactory factory : factories) {
                SaslClient saslClient = factory.createSaslClient(new String[]{mechanism}, authorizationId, protocol, serverName, props, cbh);
                if (saslClient == null) continue;
                return saslClient;
            }
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return ((ImmutableCollection)((Object)this.clientFactories.keySet())).toArray(new String[0]);
    }

    private static final class Holder {
        static final FastSaslClientFactory INSTANCE = new FastSaslClientFactory();

        private Holder() {
        }
    }
}

