/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import oadd.io.netty.buffer.ByteBuf;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.shaded.guava.com.google.common.util.concurrent.AbstractCheckedFuture;
import org.apache.drill.shaded.guava.com.google.common.util.concurrent.AbstractFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillRpcFutureImpl<V>
extends AbstractCheckedFuture<V, RpcException>
implements DrillRpcFuture<V>,
RpcOutcomeListener<V> {
    static final Logger logger = LoggerFactory.getLogger(DrillRpcFutureImpl.class);
    private volatile ByteBuf buffer;

    public DrillRpcFutureImpl() {
        super(new InnerFuture());
    }

    @Override
    protected RpcException mapException(Exception ex) {
        return RpcException.mapException(ex);
    }

    @Override
    public void failed(RpcException ex) {
        ((InnerFuture)this.delegate()).setException(ex);
    }

    @Override
    public void success(V value, ByteBuf buffer) {
        this.buffer = buffer;
        ((InnerFuture)this.delegate()).setValue(value);
    }

    @Override
    public void interrupted(InterruptedException ex) {
        ((InnerFuture)this.delegate()).cancel(true);
    }

    @Override
    public ByteBuf getBuffer() {
        return this.buffer;
    }

    public void release() {
        if (this.buffer != null) {
            this.buffer.release();
        }
    }

    private static class InnerFuture<T>
    extends AbstractFuture<T> {
        private InnerFuture() {
        }

        void setValue(T value) {
            super.set(value);
        }

        @Override
        protected boolean setException(Throwable t) {
            return super.setException(t);
        }
    }
}

