/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.Iterator;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.ExecConstants;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.SchemaChangeException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.ops.OperatorStats;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.physical.impl.aggregate.SpilledRecordbatch;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.CloseableRecordBatch;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.record.WritableBatch;
import oadd.org.apache.drill.exec.record.selection.SelectionVector2;
import oadd.org.apache.drill.exec.record.selection.SelectionVector4;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.util.record.RecordBatchStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordBatch<T extends PhysicalOperator>
implements CloseableRecordBatch {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRecordBatch.class);
    protected final VectorContainer container;
    protected final T popConfig;
    protected final FragmentContext context;
    protected final OperatorContext oContext;
    protected final RecordBatchStats.RecordBatchStatsContext batchStatsContext;
    protected final OperatorStats stats;
    protected final boolean unionTypeEnabled;
    protected BatchState state;
    private RecordBatch.IterOutcome lastOutcome;

    protected AbstractRecordBatch(T popConfig, FragmentContext context) throws OutOfMemoryException {
        this(popConfig, context, true, context.newOperatorContext((PhysicalOperator)popConfig));
    }

    protected AbstractRecordBatch(T popConfig, FragmentContext context, boolean buildSchema) throws OutOfMemoryException {
        this(popConfig, context, buildSchema, context.newOperatorContext((PhysicalOperator)popConfig));
    }

    protected AbstractRecordBatch(T popConfig, FragmentContext context, boolean buildSchema, OperatorContext oContext) {
        this.context = context;
        this.popConfig = popConfig;
        this.oContext = oContext;
        this.batchStatsContext = new RecordBatchStats.RecordBatchStatsContext(context, oContext);
        this.stats = oContext.getStats();
        this.container = new VectorContainer(this.oContext.getAllocator());
        this.state = buildSchema ? BatchState.BUILD_SCHEMA : BatchState.FIRST;
        OptionValue option = context.getOptions().getOption(ExecConstants.ENABLE_UNION_TYPE.getOptionName());
        this.unionTypeEnabled = option != null ? option.bool_val : false;
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    @Override
    public FragmentContext getContext() {
        return this.context;
    }

    public T getPopConfig() {
        return this.popConfig;
    }

    public final RecordBatch.IterOutcome next(RecordBatch b) {
        if (!this.context.getExecutorState().shouldContinue()) {
            return RecordBatch.IterOutcome.STOP;
        }
        return this.next(0, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RecordBatch.IterOutcome next(int inputIndex, RecordBatch b) {
        RecordBatch.IterOutcome next;
        this.stats.stopProcessing();
        try {
            if (!this.context.getExecutorState().shouldContinue()) {
                RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.STOP;
                return iterOutcome;
            }
            next = b.next();
        }
        finally {
            this.stats.startProcessing();
        }
        if (b instanceof SpilledRecordbatch) {
            return next;
        }
        boolean isNewSchema = false;
        logger.debug("Received next batch for index: {} with outcome: {}", (Object)inputIndex, (Object)next);
        switch (next) {
            case OK_NEW_SCHEMA: {
                isNewSchema = true;
            }
            case OK: 
            case EMIT: {
                this.stats.batchReceived(inputIndex, b.getRecordCount(), isNewSchema);
                logger.debug("Number of records in received batch: {}", (Object)b.getRecordCount());
                break;
            }
        }
        return next;
    }

    @Override
    public final RecordBatch.IterOutcome next() {
        try {
            this.stats.startProcessing();
            block2 : switch (this.state) {
                case BUILD_SCHEMA: {
                    this.buildSchema();
                    switch (this.state) {
                        case DONE: {
                            this.lastOutcome = RecordBatch.IterOutcome.NONE;
                            break block2;
                        }
                        case OUT_OF_MEMORY: {
                            this.context.getExecutorState().fail(UserException.memoryError().build(logger));
                        }
                        case STOP: {
                            this.lastOutcome = RecordBatch.IterOutcome.STOP;
                            break block2;
                        }
                    }
                    this.state = BatchState.FIRST;
                    this.lastOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                    break;
                }
                case DONE: {
                    this.lastOutcome = RecordBatch.IterOutcome.NONE;
                    break;
                }
                default: {
                    this.lastOutcome = this.innerNext();
                }
            }
            RecordBatch.IterOutcome iterOutcome = this.lastOutcome;
            return iterOutcome;
        }
        catch (SchemaChangeException e) {
            this.lastOutcome = RecordBatch.IterOutcome.STOP;
            throw new DrillRuntimeException(e);
        }
        catch (Exception e) {
            this.lastOutcome = RecordBatch.IterOutcome.STOP;
            throw e;
        }
        finally {
            this.stats.stopProcessing();
        }
    }

    public abstract RecordBatch.IterOutcome innerNext();

    @Override
    public BatchSchema getSchema() {
        if (this.container.hasSchema()) {
            return this.container.getSchema();
        }
        return null;
    }

    protected void buildSchema() throws SchemaChangeException {
    }

    @Override
    public void kill(boolean sendUpstream) {
        this.killIncoming(sendUpstream);
    }

    protected abstract void killIncoming(boolean var1);

    @Override
    public void close() {
        this.container.clear();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.container.getValueAccessorById(clazz, ids);
    }

    @Override
    public WritableBatch getWritableBatch() {
        return WritableBatch.get(this);
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        throw new UnsupportedOperationException(String.format(" You should not call getOutgoingContainer() for class %s", this.getClass().getCanonicalName()));
    }

    @Override
    public VectorContainer getContainer() {
        return this.container;
    }

    @Override
    public boolean hasFailed() {
        return this.lastOutcome == RecordBatch.IterOutcome.STOP;
    }

    public RecordBatchStats.RecordBatchStatsContext getRecordBatchStatsContext() {
        return this.batchStatsContext;
    }

    public boolean isRecordBatchStatsLoggingEnabled() {
        return this.batchStatsContext.isEnableBatchSzLogging();
    }

    public static enum BatchState {
        BUILD_SCHEMA,
        FIRST,
        NOT_FIRST,
        STOP,
        OUT_OF_MEMORY,
        DONE;

    }
}

