/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metastore;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.metastore.MetadataProviderManager;
import oadd.org.apache.drill.exec.planner.common.DrillStatsTable;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import oadd.org.apache.drill.exec.store.dfs.easy.SimpleFileTableMetadataProviderBuilder;
import oadd.org.apache.hadoop.fs.Path;
import org.apache.drill.metastore.metadata.BaseTableMetadata;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.NonInterestingColumnsMetadata;
import org.apache.drill.metastore.metadata.PartitionMetadata;
import org.apache.drill.metastore.metadata.SegmentMetadata;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.metadata.TableMetadataProvider;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileTableMetadataProvider
implements TableMetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(SimpleFileTableMetadataProvider.class);
    private final TableMetadata tableMetadata;

    private SimpleFileTableMetadataProvider(TableMetadata tableMetadata) {
        this.tableMetadata = tableMetadata;
    }

    public TableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public List<SchemaPath> getPartitionColumns() {
        return null;
    }

    public List<PartitionMetadata> getPartitionsMetadata() {
        return null;
    }

    public List<PartitionMetadata> getPartitionMetadata(SchemaPath columnName) {
        return null;
    }

    public Map<Path, FileMetadata> getFilesMetadataMap() {
        return null;
    }

    public Map<Path, SegmentMetadata> getSegmentsMetadataMap() {
        return null;
    }

    public FileMetadata getFileMetadata(Path location) {
        return null;
    }

    public List<FileMetadata> getFilesForPartition(PartitionMetadata partition) {
        return null;
    }

    public NonInterestingColumnsMetadata getNonInterestingColumnsMetadata() {
        return null;
    }

    public boolean checkMetadataVersion() {
        return false;
    }

    public static class Builder
    implements SimpleFileTableMetadataProviderBuilder {
        private String tableName;
        private Path location;
        private long lastModifiedTime = -1L;
        private TupleMetadata schema;
        private final MetadataProviderManager metadataProviderManager;

        public Builder(MetadataProviderManager source) {
            this.metadataProviderManager = source;
        }

        public SimpleFileTableMetadataProviderBuilder withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public SimpleFileTableMetadataProviderBuilder withLocation(Path location) {
            this.location = location;
            return this;
        }

        public SimpleFileTableMetadataProviderBuilder withLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public SimpleFileTableMetadataProviderBuilder withSchema(TupleMetadata schema) {
            this.schema = schema;
            return this;
        }

        public TableMetadataProvider build() {
            SchemaProvider schemaProvider = this.metadataProviderManager.getSchemaProvider();
            TableMetadataProvider source = this.metadataProviderManager.getTableMetadataProvider();
            if (source == null) {
                DrillStatsTable statsProvider = this.metadataProviderManager.getStatsProvider();
                HashMap<SchemaPath, ColumnStatistics> columnsStatistics = new HashMap<SchemaPath, ColumnStatistics>();
                if (statsProvider != null) {
                    if (!statsProvider.isMaterialized()) {
                        statsProvider.materialize();
                    }
                    if (statsProvider.isMaterialized()) {
                        for (SchemaPath column : statsProvider.getColumns()) {
                            columnsStatistics.put(column, new ColumnStatistics((Collection)DrillStatsTable.getEstimatedColumnStats((DrillStatsTable)statsProvider, (SchemaPath)column)));
                        }
                    }
                }
                TupleMetadata schema = null;
                try {
                    schema = this.schema != null ? this.schema : (schemaProvider != null ? schemaProvider.read().getSchema() : null);
                }
                catch (IOException | IllegalArgumentException e) {
                    logger.debug("Unable to read schema from schema provider [{}]: {}", this.tableName != null ? this.tableName : this.location, (Object)e.getMessage());
                    logger.trace("Error when reading the schema", e);
                }
                MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.TABLE).build();
                BaseTableMetadata tableMetadata = ((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)BaseTableMetadata.builder().tableInfo(TableInfo.UNKNOWN_TABLE_INFO)).metadataInfo(metadataInfo)).location(this.location).schema(schema)).columnsStatistics(columnsStatistics)).metadataStatistics((Collection)DrillStatsTable.getEstimatedTableStats((DrillStatsTable)statsProvider))).lastModifiedTime(this.lastModifiedTime)).partitionKeys(Collections.emptyMap()).build();
                source = new SimpleFileTableMetadataProvider((TableMetadata)tableMetadata);
                this.metadataProviderManager.setTableMetadataProvider(source);
            }
            return source;
        }
    }
}

