/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metastore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.exception.MetadataException;
import oadd.org.apache.drill.exec.metastore.FileSystemMetadataProviderManager;
import oadd.org.apache.drill.exec.metastore.MetastoreMetadataProviderManager;
import oadd.org.apache.drill.exec.metastore.ParquetTableMetadataProvider;
import oadd.org.apache.drill.exec.planner.common.DrillStatsTable;
import oadd.org.apache.drill.exec.record.SchemaUtil;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import oadd.org.apache.drill.exec.store.dfs.FileSelection;
import oadd.org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import oadd.org.apache.drill.exec.store.parquet.ParquetFileTableMetadataProviderBuilder;
import oadd.org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import oadd.org.apache.drill.exec.store.parquet.ParquetTableMetadataProviderImpl;
import oadd.org.apache.drill.exec.store.parquet.ParquetTableMetadataUtils;
import oadd.org.apache.drill.exec.util.DrillFileSystemUtil;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.PathFilter;
import org.apache.drill.metastore.MetastoreRegistry;
import org.apache.drill.metastore.components.tables.BasicTablesRequests;
import org.apache.drill.metastore.components.tables.MetastoreTableInfo;
import org.apache.drill.metastore.metadata.BaseTableMetadata;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.NonInterestingColumnsMetadata;
import org.apache.drill.metastore.metadata.PartitionMetadata;
import org.apache.drill.metastore.metadata.RowGroupMetadata;
import org.apache.drill.metastore.metadata.SegmentMetadata;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.StatisticsHolder;
import org.apache.drill.metastore.util.SchemaPathUtils;
import org.apache.drill.shaded.guava.com.google.common.collect.LinkedListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Multimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreParquetTableMetadataProvider
implements ParquetTableMetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(MetastoreParquetTableMetadataProvider.class);
    private final BasicTablesRequests basicTablesRequests;
    private final TableInfo tableInfo;
    private final MetastoreTableInfo metastoreTableInfo;
    private final TupleMetadata schema;
    private final List<ReadEntryWithPath> entries;
    private final List<String> paths;
    private final DrillStatsTable statsProvider;
    private final boolean useSchema;
    private final boolean useStatistics;
    private final boolean fallbackToFileMetadata;
    private BaseTableMetadata tableMetadata;
    private Map<Path, SegmentMetadata> segmentsMetadata;
    private List<PartitionMetadata> partitions;
    private Map<Path, FileMetadata> files;
    private Multimap<Path, RowGroupMetadata> rowGroups;
    private NonInterestingColumnsMetadata nonInterestingColumnsMetadata;
    private final ParquetFileTableMetadataProviderBuilder fallbackBuilder;
    private ParquetTableMetadataProvider fallback;

    private MetastoreParquetTableMetadataProvider(List<ReadEntryWithPath> entries, MetastoreRegistry metastoreRegistry, TableInfo tableInfo, TupleMetadata schema, ParquetFileTableMetadataProviderBuilder fallbackBuilder, MetastoreMetadataProviderManager.MetastoreMetadataProviderConfig config, DrillStatsTable statsProvider) {
        this.basicTablesRequests = metastoreRegistry.get().tables().basicRequests();
        this.tableInfo = tableInfo;
        this.metastoreTableInfo = this.basicTablesRequests.metastoreTableInfo(tableInfo);
        this.useSchema = config.useSchema();
        this.useStatistics = config.useStatistics();
        this.fallbackToFileMetadata = config.fallbackToFileMetadata();
        this.schema = schema;
        this.entries = entries == null ? new ArrayList() : entries;
        this.fallbackBuilder = fallbackBuilder;
        this.statsProvider = statsProvider;
        this.paths = this.entries.stream().map(readEntryWithPath -> readEntryWithPath.getPath().toUri().getPath()).collect(Collectors.toList());
    }

    @Override
    public boolean isUsedMetadataCache() {
        return false;
    }

    @Override
    public Path getSelectionRoot() {
        return this.getTableMetadata().getLocation();
    }

    @Override
    public List<ReadEntryWithPath> getEntries() {
        return this.entries;
    }

    @Override
    public List<RowGroupMetadata> getRowGroupsMeta() {
        return new ArrayList<RowGroupMetadata>(this.getRowGroupsMetadataMap().values());
    }

    @Override
    public List<Path> getLocations() {
        return new ArrayList<Path>(this.getFilesMetadataMap().keySet());
    }

    @Override
    public Multimap<Path, RowGroupMetadata> getRowGroupsMetadataMap() {
        this.throwIfChanged();
        if (this.rowGroups == null) {
            this.rowGroups = LinkedListMultimap.create();
            this.basicTablesRequests.rowGroupsMetadata(this.tableInfo, null, this.paths).stream().collect(Collectors.groupingBy(RowGroupMetadata::getPath, Collectors.toList())).forEach((path, rowGroupMetadata) -> this.rowGroups.putAll((Path)path, (Iterable<RowGroupMetadata>)rowGroupMetadata));
            if (this.rowGroups.isEmpty()) {
                if (this.fallbackToFileMetadata) {
                    try {
                        this.rowGroups = this.getFallbackTableMetadataProvider().getRowGroupsMetadataMap();
                    }
                    catch (IOException e) {
                        throw MetadataException.of(MetadataException.MetadataExceptionType.FALLBACK_EXCEPTION, e);
                    }
                } else {
                    throw MetadataException.of(MetadataException.MetadataExceptionType.INCOMPLETE_METADATA);
                }
            }
        }
        return this.rowGroups;
    }

    @Override
    public Set<Path> getFileSet() {
        this.throwIfChanged();
        return this.getFilesMetadataMap().keySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TableMetadata getTableMetadata() {
        this.throwIfChanged();
        if (this.tableMetadata != null) return this.tableMetadata;
        if (this.schema == null) {
            if (!this.useSchema) throw MetadataException.of(MetadataException.MetadataExceptionType.ABSENT_SCHEMA);
            this.tableMetadata = this.basicTablesRequests.tableMetadata(this.tableInfo);
        } else {
            this.tableMetadata = ((BaseTableMetadata.BaseTableMetadataBuilder)this.basicTablesRequests.tableMetadata(this.tableInfo).toBuilder().schema(this.schema)).build();
        }
        if (!this.useStatistics) {
            this.tableMetadata = ((BaseTableMetadata.BaseTableMetadataBuilder)this.tableMetadata.toBuilder().columnsStatistics(Collections.emptyMap())).build();
        }
        if (this.statsProvider == null) return this.tableMetadata;
        if (!this.statsProvider.isMaterialized()) {
            this.statsProvider.materialize();
        }
        this.tableMetadata = this.tableMetadata.cloneWithStats(ParquetTableMetadataUtils.getColumnStatistics((TupleMetadata)this.tableMetadata.getSchema(), (DrillStatsTable)this.statsProvider), DrillStatsTable.getEstimatedTableStats((DrillStatsTable)this.statsProvider));
        return this.tableMetadata;
    }

    public List<SchemaPath> getPartitionColumns() {
        this.throwIfChanged();
        return this.basicTablesRequests.interestingColumnsAndPartitionKeys(this.tableInfo).partitionKeys().values().stream().map(SchemaPath::getSimplePath).collect(Collectors.toList());
    }

    public List<PartitionMetadata> getPartitionsMetadata() {
        this.throwIfChanged();
        if (this.partitions == null) {
            this.partitions = this.basicTablesRequests.partitionsMetadata(this.tableInfo, null, null);
        }
        return this.partitions;
    }

    public List<PartitionMetadata> getPartitionMetadata(SchemaPath columnName) {
        this.throwIfChanged();
        return this.basicTablesRequests.partitionsMetadata(this.tableInfo, null, columnName.getRootSegmentPath());
    }

    public Map<Path, FileMetadata> getFilesMetadataMap() {
        this.throwIfChanged();
        if (this.files == null) {
            this.files = this.basicTablesRequests.filesMetadata(this.tableInfo, null, this.paths).stream().collect(Collectors.toMap(FileMetadata::getPath, Function.identity()));
        }
        return this.files;
    }

    public Map<Path, SegmentMetadata> getSegmentsMetadataMap() {
        this.throwIfChanged();
        if (this.segmentsMetadata == null) {
            this.segmentsMetadata = this.basicTablesRequests.segmentsMetadataByColumn(this.tableInfo, null, null).stream().collect(Collectors.toMap(SegmentMetadata::getPath, Function.identity()));
        }
        return this.segmentsMetadata;
    }

    public FileMetadata getFileMetadata(Path location) {
        this.throwIfChanged();
        return this.basicTablesRequests.fileMetadata(this.tableInfo, null, location.toUri().getPath());
    }

    public List<FileMetadata> getFilesForPartition(PartitionMetadata partition) {
        this.throwIfChanged();
        List paths = partition.getLocations().stream().map(path -> path.toUri().getPath()).collect(Collectors.toList());
        return this.basicTablesRequests.filesMetadata(this.tableInfo, null, paths);
    }

    public NonInterestingColumnsMetadata getNonInterestingColumnsMetadata() {
        this.throwIfChanged();
        if (this.nonInterestingColumnsMetadata == null) {
            TupleMetadata schema = this.getTableMetadata().getSchema();
            List<StatisticsHolder> statistics = Collections.singletonList(new StatisticsHolder((Object)-1L, (BaseStatisticsKind)ColumnStatisticsKind.NULLS_COUNT));
            List<SchemaPath> columnPaths = SchemaUtil.getSchemaPaths(schema);
            List<SchemaPath> interestingColumns = this.getInterestingColumns(columnPaths);
            Map columnsStatistics = columnPaths.stream().filter(schemaPath -> !interestingColumns.contains(schemaPath) || SchemaPathUtils.getColumnMetadata((SchemaPath)schemaPath, (TupleMetadata)schema).isArray()).collect(Collectors.toMap(Function.identity(), schemaPath -> new ColumnStatistics((Collection)statistics, SchemaPathUtils.getColumnMetadata((SchemaPath)schemaPath, (TupleMetadata)schema).type())));
            this.nonInterestingColumnsMetadata = new NonInterestingColumnsMetadata(columnsStatistics);
        }
        return this.nonInterestingColumnsMetadata;
    }

    public boolean checkMetadataVersion() {
        return true;
    }

    private List<SchemaPath> getInterestingColumns(List<SchemaPath> columnPaths) {
        if (this.useStatistics) {
            return this.getTableMetadata().getInterestingColumns() == null ? columnPaths : this.getTableMetadata().getInterestingColumns();
        }
        return Collections.emptyList();
    }

    private ParquetTableMetadataProvider getFallbackTableMetadataProvider() throws IOException {
        if (this.fallback == null) {
            this.fallback = this.fallbackBuilder == null ? null : this.fallbackBuilder.build();
        }
        return this.fallback;
    }

    private void throwIfChanged() {
        if (this.basicTablesRequests.hasMetastoreTableInfoChanged(this.metastoreTableInfo)) {
            throw MetadataException.of(MetadataException.MetadataExceptionType.INCONSISTENT_METADATA);
        }
    }

    public static class Builder
    implements ParquetFileTableMetadataProviderBuilder {
        private final MetastoreMetadataProviderManager metadataProviderManager;
        private List<ReadEntryWithPath> entries;
        private DrillFileSystem fs;
        private TupleMetadata schema;
        private FileSelection selection;
        private final ParquetFileTableMetadataProviderBuilder fallback;

        public Builder(MetastoreMetadataProviderManager source) {
            this.metadataProviderManager = source;
            this.fallback = new ParquetTableMetadataProviderImpl.Builder(FileSystemMetadataProviderManager.init());
        }

        public ParquetFileTableMetadataProviderBuilder withEntries(List<ReadEntryWithPath> entries) {
            this.entries = entries;
            this.fallback.withEntries(entries);
            return this;
        }

        public ParquetFileTableMetadataProviderBuilder withSelectionRoot(Path selectionRoot) {
            this.fallback.withSelectionRoot(selectionRoot);
            return this;
        }

        public ParquetFileTableMetadataProviderBuilder withCacheFileRoot(Path cacheFileRoot) {
            this.fallback.withCacheFileRoot(cacheFileRoot);
            return this;
        }

        public ParquetFileTableMetadataProviderBuilder withReaderConfig(ParquetReaderConfig readerConfig) {
            this.fallback.withReaderConfig(readerConfig);
            return this;
        }

        public ParquetFileTableMetadataProviderBuilder withFileSystem(DrillFileSystem fs) {
            this.fallback.withFileSystem(fs);
            this.fs = fs;
            return this;
        }

        public ParquetFileTableMetadataProviderBuilder withCorrectCorruptedDates(boolean autoCorrectCorruptedDates) {
            this.fallback.withCorrectCorruptedDates(autoCorrectCorruptedDates);
            return this;
        }

        public ParquetFileTableMetadataProviderBuilder withSelection(FileSelection selection) {
            this.fallback.withSelection(selection);
            this.selection = selection;
            return this;
        }

        public ParquetFileTableMetadataProviderBuilder withSchema(TupleMetadata schema) {
            this.fallback.withSchema(schema);
            this.schema = schema;
            return this;
        }

        public ParquetTableMetadataProvider build() throws IOException {
            SchemaProvider schemaProvider = this.metadataProviderManager.getSchemaProvider();
            ParquetTableMetadataProvider source = (ParquetTableMetadataProvider)this.metadataProviderManager.getTableMetadataProvider();
            DrillStatsTable statsProvider = this.metadataProviderManager.getStatsProvider();
            try {
                if (this.schema == null) {
                    this.schema = schemaProvider != null ? schemaProvider.read().getSchema() : null;
                }
            }
            catch (IOException e) {
                logger.debug("Unable to deserialize schema from schema file for table: {}", (Object)this.metadataProviderManager.getTableInfo().name(), (Object)e);
            }
            if (this.entries == null) {
                this.entries = !this.selection.isExpandedFully() ? DrillFileSystemUtil.listFiles((FileSystem)this.fs, this.selection.getSelectionRoot(), true, new PathFilter[0]).stream().map(fileStatus -> new ReadEntryWithPath(Path.getPathWithoutSchemeAndAuthority(fileStatus.getPath()))).collect(Collectors.toList()) : this.selection.getFiles().stream().map(Path::getPathWithoutSchemeAndAuthority).map(ReadEntryWithPath::new).collect(Collectors.toList());
            }
            MetastoreParquetTableMetadataProvider provider = new MetastoreParquetTableMetadataProvider(this.entries, this.metadataProviderManager.getMetastoreRegistry(), this.metadataProviderManager.getTableInfo(), this.schema, this.fallback, this.metadataProviderManager.getConfig(), statsProvider);
            if (source == null || source.getRowGroupsMeta().size() < provider.getRowGroupsMeta().size()) {
                this.metadataProviderManager.setTableMetadataProvider(provider);
            }
            return provider;
        }
    }
}

