/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oadd.com.google.protobuf.TextFormat;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.types.TypeProtos;

public class Types {
    public static final int MAX_VARCHAR_LENGTH = 65535;
    public static final int UNDEFINED = 0;
    public static final TypeProtos.MajorType NULL = Types.required(TypeProtos.MinorType.NULL);
    public static final TypeProtos.MajorType LATE_BIND_TYPE = Types.optional(TypeProtos.MinorType.LATE);
    public static final TypeProtos.MajorType REQUIRED_BIT = Types.required(TypeProtos.MinorType.BIT);
    public static final TypeProtos.MajorType OPTIONAL_BIT = Types.optional(TypeProtos.MinorType.BIT);
    public static final TypeProtos.MajorType OPTIONAL_INT = Types.optional(TypeProtos.MinorType.INT);

    public static boolean isUnion(TypeProtos.MajorType toType) {
        return toType.getMinorType() == TypeProtos.MinorType.UNION;
    }

    public static boolean isComplex(TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case LIST: 
            case MAP: 
            case DICT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRepeated(TypeProtos.MajorType type) {
        return type.getMode() == TypeProtos.DataMode.REPEATED;
    }

    public static boolean isNumericType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        return Types.isNumericType(type.getMinorType());
    }

    public static boolean isNumericType(TypeProtos.MinorType type) {
        switch (type) {
            case BIGINT: 
            case VARDECIMAL: 
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: 
            case FLOAT4: 
            case FLOAT8: 
            case INT: 
            case MONEY: 
            case SMALLINT: 
            case TINYINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDateTimeType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        return Types.isDateTimeType(type.getMinorType());
    }

    public static boolean isDateTimeType(TypeProtos.MinorType type) {
        switch (type) {
            case TIME: 
            case TIMETZ: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMPTZ: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntervalType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        return Types.isIntervalType(type.getMinorType());
    }

    public static boolean isIntervalType(TypeProtos.MinorType type) {
        switch (type) {
            case INTERVAL: 
            case INTERVALDAY: 
            case INTERVALYEAR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDecimalType(TypeProtos.MajorType type) {
        return Types.isDecimalType(type.getMinorType());
    }

    public static boolean isDecimalType(TypeProtos.MinorType minorType) {
        switch (minorType) {
            case VARDECIMAL: 
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: {
                return true;
            }
        }
        return false;
    }

    public static String getSqlTypeName(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED || type.getMinorType() == TypeProtos.MinorType.LIST) {
            return "ARRAY";
        }
        return Types.getBaseSqlTypeName(type);
    }

    public static String getBaseSqlTypeName(TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case BIT: {
                return "BOOLEAN";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INT: {
                return "INTEGER";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case FLOAT4: {
                return "FLOAT";
            }
            case FLOAT8: {
                return "DOUBLE";
            }
            case VARDECIMAL: 
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: {
                return "DECIMAL";
            }
            case VARCHAR: {
                return "CHARACTER VARYING";
            }
            case FIXEDCHAR: {
                return "CHARACTER";
            }
            case VAR16CHAR: {
                return "NATIONAL CHARACTER VARYING";
            }
            case FIXED16CHAR: {
                return "NATIONAL CHARACTER";
            }
            case VARBINARY: {
                return "BINARY VARYING";
            }
            case FIXEDBINARY: {
                return "BINARY";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIME";
            }
            case TIMETZ: {
                return "TIME WITH TIME ZONE";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case TIMESTAMPTZ: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case INTERVALYEAR: {
                return "INTERVAL YEAR TO MONTH";
            }
            case INTERVALDAY: {
                return "INTERVAL DAY TO SECOND";
            }
            case INTERVAL: {
                return "INTERVAL";
            }
            case MONEY: {
                return "DECIMAL";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case MAP: {
                return "STRUCT";
            }
            case DICT: {
                return "MAP";
            }
            case LATE: {
                return "ANY";
            }
            case NULL: {
                return "NULL";
            }
            case UNION: {
                return "UNION";
            }
            case GENERIC_OBJECT: {
                return "JAVA_OBJECT";
            }
            case UINT1: {
                return "TINYINT";
            }
            case UINT2: {
                return "SMALLINT";
            }
            case UINT4: {
                return "INTEGER";
            }
            case UINT8: {
                return "BIGINT";
            }
        }
        throw new AssertionError((Object)("Unexpected/unhandled MinorType value " + type.getMinorType()));
    }

    public static String getExtendedSqlTypeName(TypeProtos.MajorType type) {
        String typeName = Types.getSqlTypeName(type);
        switch (type.getMinorType()) {
            case VARDECIMAL: 
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: {
                if (type.getPrecision() <= 0) break;
                typeName = typeName + String.format("(%d, %d)", type.getPrecision(), type.getScale());
            }
        }
        return typeName;
    }

    public static String getSqlModeName(TypeProtos.MajorType type) {
        switch (type.getMode()) {
            case REQUIRED: {
                return "NOT NULL";
            }
            case OPTIONAL: {
                return "NULLABLE";
            }
            case REPEATED: {
                return "ARRAY";
            }
        }
        return "UNKNOWN";
    }

    public static int getJdbcTypeCode(String sqlTypeName) {
        switch (sqlTypeName) {
            case "ANY": {
                return 1111;
            }
            case "ARRAY": {
                return 1111;
            }
            case "BIGINT": {
                return -5;
            }
            case "BINARY VARYING": {
                return -3;
            }
            case "BINARY": {
                return -2;
            }
            case "BOOLEAN": {
                return 16;
            }
            case "CHARACTER VARYING": {
                return 12;
            }
            case "CHARACTER": {
                return -15;
            }
            case "DATE": {
                return 91;
            }
            case "DECIMAL": {
                return 3;
            }
            case "DOUBLE": {
                return 8;
            }
            case "FLOAT": {
                return 6;
            }
            case "INTEGER": {
                return 4;
            }
            case "INTERVAL": {
                return 1111;
            }
            case "INTERVAL YEAR TO MONTH": {
                return 1111;
            }
            case "INTERVAL DAY TO SECOND": {
                return 1111;
            }
            case "STRUCT": {
                return 1111;
            }
            case "MAP": {
                return 1111;
            }
            case "NATIONAL CHARACTER VARYING": {
                return -9;
            }
            case "NATIONAL CHARACTER": {
                return -15;
            }
            case "NULL": {
                return 0;
            }
            case "SMALLINT": {
                return 5;
            }
            case "TIME WITH TIME ZONE": 
            case "TIME": {
                return 92;
            }
            case "TIMESTAMP WITH TIME ZONE": 
            case "TIMESTAMP": {
                return 93;
            }
            case "TINYINT": {
                return -6;
            }
            case "UNION": {
                return 1111;
            }
            case "JAVA_OBJECT": {
                return 2000;
            }
        }
        throw new UnsupportedOperationException("Unexpected/unhandled SqlType value " + sqlTypeName);
    }

    public static boolean isJdbcSignedType(TypeProtos.MajorType type) {
        boolean isSigned;
        block0 : switch (type.getMode()) {
            case REPEATED: {
                isSigned = false;
                break;
            }
            case REQUIRED: 
            case OPTIONAL: {
                switch (type.getMinorType()) {
                    case BIGINT: 
                    case VARDECIMAL: 
                    case DECIMAL38SPARSE: 
                    case DECIMAL38DENSE: 
                    case DECIMAL28SPARSE: 
                    case DECIMAL28DENSE: 
                    case DECIMAL18: 
                    case DECIMAL9: 
                    case FLOAT4: 
                    case FLOAT8: 
                    case INT: 
                    case MONEY: 
                    case SMALLINT: 
                    case TINYINT: 
                    case INTERVAL: 
                    case INTERVALDAY: 
                    case INTERVALYEAR: {
                        isSigned = true;
                        break block0;
                    }
                    case LIST: 
                    case MAP: 
                    case DICT: 
                    case UINT1: 
                    case UINT2: 
                    case UINT4: 
                    case UINT8: 
                    case TIME: 
                    case TIMETZ: 
                    case DATE: 
                    case TIMESTAMP: 
                    case TIMESTAMPTZ: 
                    case BIT: 
                    case VARCHAR: 
                    case FIXEDCHAR: 
                    case VAR16CHAR: 
                    case FIXED16CHAR: 
                    case VARBINARY: 
                    case FIXEDBINARY: 
                    case LATE: 
                    case NULL: 
                    case UNION: 
                    case GENERIC_OBJECT: {
                        isSigned = false;
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("Unexpected/unhandled MinorType value " + type.getMinorType());
            }
            default: {
                throw new UnsupportedOperationException("Unexpected/unhandled DataMode value " + type.getMode());
            }
        }
        return isSigned;
    }

    public static int getJdbcDisplaySize(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED || type.getMinorType() == TypeProtos.MinorType.LIST) {
            return 0;
        }
        int precision = Types.getPrecision(type);
        switch (type.getMinorType()) {
            case BIT: {
                return 1;
            }
            case TINYINT: {
                return 4;
            }
            case SMALLINT: {
                return 6;
            }
            case INT: {
                return 11;
            }
            case BIGINT: {
                return 20;
            }
            case UINT1: {
                return 3;
            }
            case UINT2: {
                return 5;
            }
            case UINT4: {
                return 10;
            }
            case UINT8: {
                return 19;
            }
            case FLOAT4: {
                return 14;
            }
            case FLOAT8: {
                return 24;
            }
            case VARDECIMAL: 
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: 
            case MONEY: {
                return 2 + precision;
            }
            case VARCHAR: 
            case FIXEDCHAR: 
            case VAR16CHAR: 
            case FIXED16CHAR: {
                return precision;
            }
            case VARBINARY: 
            case FIXEDBINARY: {
                return 2 * precision;
            }
            case DATE: {
                return 10;
            }
            case TIME: {
                return precision > 0 ? 9 + precision : 8;
            }
            case TIMETZ: {
                return precision > 0 ? 15 + precision : 14;
            }
            case TIMESTAMP: {
                return precision > 0 ? 20 + precision : 19;
            }
            case TIMESTAMPTZ: {
                return precision > 0 ? 26 + precision : 25;
            }
            case INTERVALYEAR: {
                return precision > 0 ? 5 + precision : 9;
            }
            case INTERVALDAY: {
                return precision > 0 ? 12 + precision : 22;
            }
            case MAP: 
            case DICT: 
            case INTERVAL: 
            case LATE: 
            case NULL: 
            case UNION: {
                return 0;
            }
        }
        throw new UnsupportedOperationException("Unexpected/unhandled MinorType value " + type.getMinorType());
    }

    public static boolean usesHolderForGet(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return true;
        }
        switch (type.getMinorType()) {
            case BIGINT: 
            case FLOAT4: 
            case FLOAT8: 
            case INT: 
            case MONEY: 
            case SMALLINT: 
            case TINYINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: 
            case TIME: 
            case DATE: 
            case TIMESTAMP: 
            case INTERVALYEAR: {
                return false;
            }
        }
        return true;
    }

    public static boolean isFixedWidthType(TypeProtos.MajorType type) {
        return Types.isFixedWidthType(type.getMinorType());
    }

    public static boolean isFixedWidthType(TypeProtos.MinorType type) {
        return !Types.isVarWidthType(type);
    }

    public static boolean isVarWidthType(TypeProtos.MinorType type) {
        switch (type) {
            case VARDECIMAL: 
            case VARCHAR: 
            case VAR16CHAR: 
            case VARBINARY: 
            case UNION: {
                return true;
            }
        }
        return false;
    }

    public static boolean isScalarStringType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        switch (type.getMinorType()) {
            case VARCHAR: 
            case FIXEDCHAR: 
            case VAR16CHAR: 
            case FIXED16CHAR: {
                return true;
            }
        }
        return false;
    }

    public static boolean softEquals(TypeProtos.MajorType a, TypeProtos.MajorType b, boolean allowNullSwap) {
        if (a.getMinorType() != b.getMinorType()) {
            return false;
        }
        if (allowNullSwap) {
            switch (a.getMode()) {
                case REQUIRED: 
                case OPTIONAL: {
                    switch (b.getMode()) {
                        case REQUIRED: 
                        case OPTIONAL: {
                            return true;
                        }
                    }
                }
            }
        }
        return a.getMode() == b.getMode();
    }

    public static boolean isUntypedNull(TypeProtos.MajorType type) {
        return type.getMinorType() == TypeProtos.MinorType.NULL;
    }

    public static TypeProtos.MajorType withMode(TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        return TypeProtos.MajorType.newBuilder().setMode(mode).setMinorType(type).build();
    }

    public static TypeProtos.MajorType withPrecision(TypeProtos.MinorType type, TypeProtos.DataMode mode, int precision) {
        return TypeProtos.MajorType.newBuilder().setMinorType(type).setMode(mode).setPrecision(precision).build();
    }

    public static TypeProtos.MajorType withPrecisionAndScale(TypeProtos.MinorType type, TypeProtos.DataMode mode, int precision, int scale) {
        return TypeProtos.MajorType.newBuilder().setMinorType(type).setMode(mode).setScale(scale).setPrecision(precision).build();
    }

    public static TypeProtos.MajorType required(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REQUIRED).setMinorType(type).build();
    }

    public static TypeProtos.MajorType repeated(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REPEATED).setMinorType(type).build();
    }

    public static TypeProtos.MajorType optional(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.OPTIONAL).setMinorType(type).build();
    }

    public static TypeProtos.MajorType overrideMode(TypeProtos.MajorType originalMajorType, TypeProtos.DataMode overrideMode) {
        return originalMajorType.toBuilder().setMode(overrideMode).build();
    }

    public static TypeProtos.MajorType getMajorTypeFromName(String typeName) {
        return Types.getMajorTypeFromName(typeName, TypeProtos.DataMode.REQUIRED);
    }

    public static TypeProtos.MinorType getMinorTypeFromName(String typeName) {
        switch (typeName = typeName.toLowerCase()) {
            case "bool": 
            case "boolean": {
                return TypeProtos.MinorType.BIT;
            }
            case "tinyint": {
                return TypeProtos.MinorType.TINYINT;
            }
            case "uint1": {
                return TypeProtos.MinorType.UINT1;
            }
            case "smallint": {
                return TypeProtos.MinorType.SMALLINT;
            }
            case "uint2": {
                return TypeProtos.MinorType.UINT2;
            }
            case "integer": 
            case "int": {
                return TypeProtos.MinorType.INT;
            }
            case "uint4": {
                return TypeProtos.MinorType.UINT4;
            }
            case "bigint": {
                return TypeProtos.MinorType.BIGINT;
            }
            case "uint8": {
                return TypeProtos.MinorType.UINT8;
            }
            case "float": {
                return TypeProtos.MinorType.FLOAT4;
            }
            case "double": {
                return TypeProtos.MinorType.FLOAT8;
            }
            case "decimal": {
                return TypeProtos.MinorType.VARDECIMAL;
            }
            case "symbol": 
            case "char": 
            case "utf8": 
            case "varchar": {
                return TypeProtos.MinorType.VARCHAR;
            }
            case "utf16": 
            case "string": 
            case "var16char": {
                return TypeProtos.MinorType.VAR16CHAR;
            }
            case "timestamp": {
                return TypeProtos.MinorType.TIMESTAMP;
            }
            case "interval_year_month": {
                return TypeProtos.MinorType.INTERVALYEAR;
            }
            case "interval_day_time": {
                return TypeProtos.MinorType.INTERVALDAY;
            }
            case "date": {
                return TypeProtos.MinorType.DATE;
            }
            case "time": {
                return TypeProtos.MinorType.TIME;
            }
            case "binary": {
                return TypeProtos.MinorType.VARBINARY;
            }
            case "json": 
            case "simplejson": 
            case "extendedjson": {
                return TypeProtos.MinorType.LATE;
            }
            case "null": 
            case "any": {
                return TypeProtos.MinorType.NULL;
            }
        }
        throw new UnsupportedOperationException("Could not determine type: " + typeName);
    }

    public static TypeProtos.MajorType getMajorTypeFromName(String typeName, TypeProtos.DataMode mode) {
        return Types.withMode(Types.getMinorTypeFromName(typeName), mode);
    }

    public static String getNameOfMinorType(TypeProtos.MinorType type) {
        switch (type) {
            case BIT: {
                return "bool";
            }
            case TINYINT: {
                return "tinyint";
            }
            case UINT1: {
                return "uint1";
            }
            case SMALLINT: {
                return "smallint";
            }
            case UINT2: {
                return "uint2";
            }
            case INT: {
                return "int";
            }
            case UINT4: {
                return "uint4";
            }
            case BIGINT: {
                return "bigint";
            }
            case UINT8: {
                return "uint8";
            }
            case FLOAT4: {
                return "float";
            }
            case FLOAT8: {
                return "double";
            }
            case VARDECIMAL: 
            case DECIMAL38SPARSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL18: 
            case DECIMAL9: {
                return "decimal";
            }
            case VARCHAR: {
                return "varchar";
            }
            case VAR16CHAR: {
                return "utf16";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case VARBINARY: {
                return "binary";
            }
            case LATE: {
                throw new DrillRuntimeException("The late type should never appear in execution or an SQL query, so it does not have a name to refer to it.");
            }
        }
        throw new DrillRuntimeException("Unrecognized type " + type);
    }

    public static String toString(TypeProtos.MajorType type) {
        return type != null ? "MajorType[" + TextFormat.shortDebugString(type) + "]" : "null";
    }

    public static int getPrecision(TypeProtos.MajorType majorType) {
        if (majorType.hasPrecision()) {
            return majorType.getPrecision();
        }
        return Types.isScalarStringType(majorType) ? 65535 : 0;
    }

    public static int getScale(TypeProtos.MajorType majorType) {
        if (majorType.hasScale()) {
            return majorType.getScale();
        }
        return 0;
    }

    public static boolean isSortable(TypeProtos.MinorType type) {
        switch (type) {
            case LIST: 
            case MAP: 
            case DICT: {
                return false;
            }
        }
        return true;
    }

    public static TypeProtos.MajorType.Builder calculateTypePrecisionAndScale(TypeProtos.MajorType leftType, TypeProtos.MajorType rightType, TypeProtos.MajorType.Builder typeBuilder) {
        if (leftType.getMinorType().equals(rightType.getMinorType())) {
            boolean isScalarString = Types.isScalarStringType(leftType) && Types.isScalarStringType(rightType);
            boolean isDecimal = Types.isDecimalType(leftType);
            if ((isScalarString || isDecimal) && leftType.hasPrecision() && rightType.hasPrecision()) {
                typeBuilder.setPrecision(Math.max(leftType.getPrecision(), rightType.getPrecision()));
            }
            if (isDecimal && leftType.hasScale() && rightType.hasScale()) {
                typeBuilder.setScale(Math.max(leftType.getScale(), rightType.getScale()));
            }
        }
        return typeBuilder;
    }

    public static boolean isSameType(TypeProtos.MajorType type1, TypeProtos.MajorType type2) {
        return type1.getMinorType() == type2.getMinorType() && type1.getMode() == type2.getMode() && type1.getScale() == type2.getScale() && type1.getPrecision() == type2.getPrecision();
    }

    public static boolean isEquivalent(TypeProtos.MajorType type1, TypeProtos.MajorType type2) {
        List<TypeProtos.MinorType> subtypes2;
        if (!Types.isSameType(type1, type2)) {
            return false;
        }
        if (type1.getMinorType() != TypeProtos.MinorType.UNION) {
            return true;
        }
        List<TypeProtos.MinorType> subtypes1 = type1.getSubTypeList();
        if (subtypes1 == (subtypes2 = type2.getSubTypeList())) {
            return true;
        }
        if (subtypes1 == null || subtypes2 == null) {
            return false;
        }
        if (subtypes1.size() != subtypes2.size()) {
            return false;
        }
        ArrayList<TypeProtos.MinorType> copy1 = new ArrayList<TypeProtos.MinorType>(subtypes1);
        ArrayList<TypeProtos.MinorType> copy2 = new ArrayList<TypeProtos.MinorType>(subtypes2);
        Collections.sort(copy1);
        Collections.sort(copy2);
        return copy1.equals(copy2);
    }

    public static String typeKey(TypeProtos.MinorType type) {
        return type.name().toLowerCase();
    }

    public static int maxPrecision(TypeProtos.MinorType type) {
        switch (type) {
            case DECIMAL18: {
                return 18;
            }
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: {
                return 28;
            }
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: {
                return 38;
            }
            case DECIMAL9: {
                return 9;
            }
            case VARDECIMAL: {
                return 38;
            }
        }
        return 0;
    }

    public static boolean isNullable(TypeProtos.MajorType type) {
        switch (type.getMode()) {
            case REQUIRED: 
            case REPEATED: {
                return false;
            }
            case OPTIONAL: {
                return !Types.isComplex(type);
            }
        }
        throw new UnsupportedOperationException("Unexpected/unhandled DataMode value " + type.getMode());
    }
}

