/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.x.discovery.details;

import java.util.List;
import oadd.com.google.common.base.Predicate;
import oadd.com.google.common.base.Predicates;
import oadd.com.google.common.collect.ImmutableList;
import oadd.com.google.common.collect.Iterables;
import oadd.org.apache.curator.x.discovery.InstanceFilter;
import oadd.org.apache.curator.x.discovery.ServiceInstance;
import oadd.org.apache.curator.x.discovery.details.InstanceProvider;

class FilteredInstanceProvider<T>
implements InstanceProvider<T> {
    private final InstanceProvider<T> instanceProvider;
    private final Predicate<ServiceInstance<T>> predicates;

    FilteredInstanceProvider(InstanceProvider<T> instanceProvider, List<InstanceFilter<T>> filters) {
        this.instanceProvider = instanceProvider;
        this.predicates = Predicates.and(filters);
    }

    @Override
    public List<ServiceInstance<T>> getInstances() throws Exception {
        Iterable<ServiceInstance<T>> filtered = Iterables.filter(this.instanceProvider.getInstances(), this.predicates);
        return ImmutableList.copyOf(filtered);
    }
}

