/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.dbcp2.managed;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import oadd.org.apache.commons.dbcp2.Utils;
import oadd.org.apache.commons.dbcp2.managed.TransactionRegistry;
import oadd.org.apache.commons.dbcp2.managed.XAConnectionFactory;

public class DataSourceXAConnectionFactory
implements XAConnectionFactory {
    private final TransactionRegistry transactionRegistry;
    private final XADataSource xaDataSource;
    private String userName;
    private char[] userPassword;

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xaDataSource) {
        this(transactionManager, xaDataSource, null, null, null);
    }

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xaDataSource, String userName, char[] userPassword) {
        this(transactionManager, xaDataSource, userName, userPassword, null);
    }

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xaDataSource, String userName, char[] userPassword, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Objects.requireNonNull(transactionManager, "transactionManager is null");
        Objects.requireNonNull(xaDataSource, "xaDataSource is null");
        this.transactionRegistry = new TransactionRegistry(transactionManager, transactionSynchronizationRegistry);
        this.xaDataSource = xaDataSource;
        this.userName = userName;
        this.userPassword = userPassword;
    }

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xaDataSource, String userName, String userPassword) {
        this(transactionManager, xaDataSource, userName, Utils.toCharArray(userPassword), null);
    }

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xaDataSource, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this(transactionManager, xaDataSource, null, null, transactionSynchronizationRegistry);
    }

    @Override
    public Connection createConnection() throws SQLException {
        XAConnection xaConnection = this.userName == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(this.userName, Utils.toString(this.userPassword));
        Connection connection = xaConnection.getConnection();
        XAResource xaResource = xaConnection.getXAResource();
        this.transactionRegistry.registerConnection(connection, xaResource);
        xaConnection.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent event) {
                PooledConnection pc = (PooledConnection)event.getSource();
                pc.removeConnectionEventListener(this);
                try {
                    pc.close();
                }
                catch (SQLException e) {
                    System.err.println("Failed to close XAConnection");
                    e.printStackTrace();
                }
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent event) {
                this.connectionClosed(event);
            }
        });
        return connection;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Deprecated
    public String getUsername() {
        return this.userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public char[] getUserPassword() {
        return this.userPassword;
    }

    public XADataSource getXaDataSource() {
        return this.xaDataSource;
    }

    public void setPassword(char[] userPassword) {
        this.userPassword = userPassword;
    }

    public void setPassword(String userPassword) {
        this.userPassword = Utils.toCharArray(userPassword);
    }

    public void setUsername(String userName) {
        this.userName = userName;
    }
}

