/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.module.afterburner.util;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oadd.com.fasterxml.jackson.module.afterburner.util.ClassName;

public class MyClassLoader
extends ClassLoader {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final ConcurrentHashMap<String, Object> parentParallelLockMap = new ConcurrentHashMap();
    protected final boolean _cfgUseParentLoader;

    public MyClassLoader(ClassLoader parent, boolean tryToUseParent) {
        super(parent);
        this._cfgUseParentLoader = tryToUseParent;
    }

    public static boolean canAddClassInPackageOf(Class<?> cls) {
        Package beanPackage = cls.getPackage();
        if (beanPackage != null) {
            if (beanPackage.isSealed()) {
                return false;
            }
            String pname = beanPackage.getName();
            if (pname.startsWith("java.") || pname.startsWith("javax.security.")) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadAndResolve(ClassName className, byte[] byteCode) throws IllegalArgumentException {
        Class<?> classFromParent = this.loadAndResolveUsingParentClassloader(className, byteCode);
        if (classFromParent != null) {
            return classFromParent;
        }
        Object object = this.getClassLoadingLock(className.getDottedName());
        synchronized (object) {
            Class<?> newClass;
            Class<?> existingClass = this.findLoadedClass(className.getDottedName());
            if (existingClass != null) {
                return existingClass;
            }
            MyClassLoader.replaceName(byteCode, className.getSlashedTemplate(), className.getSlashedName());
            try {
                newClass = this.defineClass(className.getDottedName(), byteCode, 0, byteCode.length);
            }
            catch (LinkageError e) {
                Throwable t = e;
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                throw new IllegalArgumentException("Failed to load class '" + className + "': " + t.getMessage(), t);
            }
            this.resolveClass(newClass);
            return newClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadAndResolveUsingParentClassloader(ClassName className, byte[] byteCode) {
        ClassLoader parentClassLoader;
        if (!this._cfgUseParentLoader || (parentClassLoader = this.getParent()) == null) {
            return null;
        }
        Object object = this.getParentClassLoadingLock(parentClassLoader, className.getDottedName());
        synchronized (object) {
            Class<?> impl = this.findLoadedClassOnParent(parentClassLoader, className.getDottedName());
            if (impl != null) {
                return impl;
            }
            MyClassLoader.replaceName(byteCode, className.getSlashedTemplate(), className.getSlashedName());
            impl = this.defineClassOnParent(parentClassLoader, className.getDottedName(), byteCode, 0, byteCode.length);
            this.resolveClassOnParent(parentClassLoader, impl);
            return impl;
        }
    }

    private Object getParentClassLoadingLock(ClassLoader parentClassLoader, String className) {
        Object newLock;
        String key = parentClassLoader.getClass().getCanonicalName() + ":" + System.identityHashCode(parentClassLoader) + ":" + className;
        Object lock = parentParallelLockMap.putIfAbsent(key, newLock = new Object());
        if (lock == null) {
            lock = newLock;
        }
        return lock;
    }

    private Class<?> findLoadedClassOnParent(ClassLoader parentClassLoader, String className) {
        try {
            Method method = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            method.setAccessible(true);
            return (Class)method.invoke((Object)parentClassLoader, className);
        }
        catch (Exception e) {
            String msg = String.format("Exception trying 'findLoadedClass(%s)' on parent ClassLoader '%s'", className, parentClassLoader);
            Logger.getLogger(MyClassLoader.class.getName()).log(Level.FINE, msg, e);
            return null;
        }
    }

    Class<?> defineClassOnParent(ClassLoader parentClassLoader, String className, byte[] byteCode, int offset, int length) {
        try {
            Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return (Class)method.invoke((Object)parentClassLoader, className, byteCode, offset, length);
        }
        catch (Exception e) {
            String msg = String.format("Exception trying 'defineClass(%s, <bytecode>)' on parent ClassLoader '%s'", className, parentClassLoader);
            Logger.getLogger(MyClassLoader.class.getName()).log(Level.FINE, msg, e);
            return null;
        }
    }

    private void resolveClassOnParent(ClassLoader parentClassLoader, Class<?> clazz) {
        try {
            Method method = ClassLoader.class.getDeclaredMethod("resolveClass", Class.class);
            method.setAccessible(true);
            method.invoke((Object)parentClassLoader, clazz);
        }
        catch (Exception e) {
            String msg = String.format("Exception trying 'resolveClass(%s)' on parent ClassLoader '%s'", clazz, parentClassLoader);
            Logger.getLogger(MyClassLoader.class.getName()).log(Level.FINE, msg, e);
        }
    }

    public static int replaceName(byte[] byteCode, String from, String to) {
        byte[] toB;
        byte[] fromB = from.getBytes(UTF8);
        int matchLength = fromB.length;
        if (matchLength != (toB = to.getBytes(UTF8)).length) {
            throw new IllegalArgumentException("From String '" + from + "' has different length than To String '" + to + "'");
        }
        int i = 0;
        int count = 0;
        int end = byteCode.length - matchLength;
        block0: while (i <= end) {
            if (byteCode[i++] != fromB[0]) continue;
            for (int j = 1; j < matchLength; ++j) {
                if (fromB[j] != byteCode[i + j - 1]) continue block0;
            }
            ++count;
            System.arraycopy(toB, 0, byteCode, i - 1, matchLength);
            i += matchLength - 1;
        }
        return count;
    }
}

