/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.datatype.joda.deser;

import java.io.IOException;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import oadd.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import oadd.com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import oadd.org.joda.time.LocalTime;

public class LocalTimeDeserializer
extends JodaDateDeserializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;

    public LocalTimeDeserializer() {
        this(FormatConfig.DEFAULT_LOCAL_TIMEONLY_PARSER);
    }

    public LocalTimeDeserializer(JacksonJodaDateFormat format) {
        super(LocalTime.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new LocalTimeDeserializer(format);
    }

    @Override
    public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentToken()) {
            case START_ARRAY: {
                if (!p.isExpectedStartArrayToken()) break;
                p.nextToken();
                int hour = p.getIntValue();
                p.nextToken();
                int minute = p.getIntValue();
                p.nextToken();
                int second = p.getIntValue();
                p.nextToken();
                int millis = 0;
                if (p.getCurrentToken() != JsonToken.END_ARRAY) {
                    millis = p.getIntValue();
                    p.nextToken();
                }
                if (p.getCurrentToken() != JsonToken.END_ARRAY) {
                    throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.END_ARRAY, "after LocalTime ints");
                }
                return new LocalTime(hour, minute, second, millis);
            }
            case VALUE_NUMBER_INT: {
                return new LocalTime(p.getLongValue());
            }
            case VALUE_STRING: {
                String str = p.getText().trim();
                return str.length() == 0 ? null : this._format.createParser(ctxt).parseLocalTime(str);
            }
        }
        return (LocalTime)ctxt.handleUnexpectedToken(this.handledType(), p.getCurrentToken(), p, "expected JSON Array, String or Number", new Object[0]);
    }
}

