/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.codehaus.janino.util.resource;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oadd.org.codehaus.commons.nullanalysis.Nullable;
import oadd.org.codehaus.janino.util.resource.FileResourceFinder;

public class DirectoryResourceFinder
extends FileResourceFinder {
    private final File directory;
    private final Map<String, Set<File>> subdirectoryNameToFiles = new HashMap<String, Set<File>>();

    public DirectoryResourceFinder(File directory) {
        this.directory = directory;
    }

    public final String toString() {
        return "dir:" + this.directory;
    }

    @Override
    @Nullable
    protected final File findResourceAsFile(String resourceName) {
        File file;
        int idx = resourceName.lastIndexOf(47);
        String subdirectoryName = idx == -1 ? null : resourceName.substring(0, idx).replace('/', File.separatorChar);
        HashSet<File> files = this.subdirectoryNameToFiles.get(subdirectoryName);
        if (files == null) {
            File subDirectory = subdirectoryName == null ? this.directory : new File(this.directory, subdirectoryName);
            File[] fa = subDirectory.listFiles();
            files = fa == null ? Collections.emptySet() : new HashSet<File>(Arrays.asList(fa));
            this.subdirectoryNameToFiles.put(subdirectoryName, files);
        }
        if (!files.contains(file = new File(this.directory, resourceName.replace('/', File.separatorChar)))) {
            return null;
        }
        return file;
    }
}

