/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.exec.expr.holders.RepeatedMapHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.complex.RepeatedMapVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractRepeatedMapReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.impl.NullReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedMapWriter;
import oadd.org.apache.drill.exec.vector.complex.impl.SingleLikeRepeatedMapReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.impl.SingleMapWriter;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class RepeatedMapReaderImpl
extends AbstractRepeatedMapReaderImpl<RepeatedMapVector> {
    public RepeatedMapReaderImpl(RepeatedMapVector vector) {
        super(vector);
    }

    @Override
    public FieldReader reader() {
        if (this.isEmpty()) {
            return NullReader.INSTANCE;
        }
        this.setChildrenPosition(this.currentOffset);
        return new SingleLikeRepeatedMapReaderImpl((RepeatedMapVector)this.vector, this);
    }

    public void setSinglePosition(int index, int childIndex) {
        super.setPosition(index);
        RepeatedMapHolder h = new RepeatedMapHolder();
        ((RepeatedMapVector)this.vector).getAccessor().get(index, h);
        if (h.start == h.end) {
            this.currentOffset = 0x7FFFFFFE;
        } else {
            int singleOffset = h.start + childIndex;
            assert (singleOffset < h.end);
            this.currentOffset = singleOffset;
            this.maxOffset = singleOffset + 1;
            this.setChildrenPosition(singleOffset);
        }
    }

    @Override
    public MaterializedField getField() {
        return ((RepeatedMapVector)this.vector).getField();
    }

    @Override
    public void copyAsValue(BaseWriter.MapWriter writer) {
        if (this.isEmpty()) {
            return;
        }
        RepeatedMapWriter impl = (RepeatedMapWriter)writer;
        ((RepeatedMapVector)impl.container).copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    public void copyAsValueSingle(BaseWriter.MapWriter writer) {
        if (this.isEmpty()) {
            return;
        }
        SingleMapWriter impl = (SingleMapWriter)writer;
        impl.container.copyFromSafe(this.currentOffset, impl.idx(), (RepeatedMapVector)this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        if (this.isEmpty()) {
            return;
        }
        RepeatedMapWriter impl = (RepeatedMapWriter)writer.map(name);
        ((RepeatedMapVector)impl.container).copyFromSafe(this.idx(), impl.idx(), this.vector);
    }
}

