/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.RepeatedDictHolder;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedDictVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.NullReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedDictWriter;
import oadd.org.apache.drill.exec.vector.complex.impl.SingleDictWriter;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class RepeatedDictReaderImpl
extends AbstractFieldReader {
    private static final int NO_VALUES = Integer.MIN_VALUE;
    private final RepeatedDictVector container;
    private FieldReader reader;
    private int currentOffset;
    private int maxOffset;

    public RepeatedDictReaderImpl(RepeatedDictVector container) {
        this.container = container;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return RepeatedDictVector.TYPE;
    }

    @Override
    public void reset() {
        super.reset();
        this.currentOffset = 0;
        this.maxOffset = 0;
        if (this.reader != null) {
            this.reader.reset();
        }
        this.reader = null;
    }

    @Override
    public int size() {
        return this.isEmpty() ? 0 : this.maxOffset - this.currentOffset;
    }

    @Override
    public void setPosition(int index) {
        if (index < 0) {
            this.currentOffset = Integer.MIN_VALUE;
            return;
        }
        super.setPosition(index);
        RepeatedDictHolder h = new RepeatedDictHolder();
        this.container.getAccessor().get(index, h);
        if (h.start == h.end) {
            this.currentOffset = Integer.MIN_VALUE;
        } else {
            this.currentOffset = h.start - 1;
            this.maxOffset = h.end - 1;
            if (this.reader != null) {
                this.reader.setPosition(this.currentOffset);
            }
        }
    }

    @Override
    public boolean next() {
        if (this.currentOffset < this.maxOffset) {
            ++this.currentOffset;
            if (this.reader != null) {
                this.reader.setPosition(this.currentOffset);
            }
            return true;
        }
        this.currentOffset = Integer.MIN_VALUE;
        return false;
    }

    @Override
    public Object readObject() {
        return this.container.getAccessor().getObject(this.idx());
    }

    @Override
    public FieldReader reader() {
        if (this.reader == null) {
            ValueVector child = this.container.getDataVector();
            this.reader = child == null ? NullReader.INSTANCE : child.getReader();
            this.reader.setPosition(this.currentOffset);
        }
        return this.reader;
    }

    public boolean isEmpty() {
        return this.currentOffset == Integer.MIN_VALUE;
    }

    @Override
    public void copyAsValue(BaseWriter.DictWriter writer) {
        int srcId;
        RepeatedValueVector vector;
        if (this.isEmpty()) {
            return;
        }
        if (writer instanceof RepeatedDictWriter) {
            vector = ((RepeatedDictWriter)writer).container;
            srcId = ((RepeatedDictWriter)writer).idx();
        } else {
            vector = ((SingleDictWriter)writer).container;
            srcId = ((SingleDictWriter)writer).idx();
        }
        vector.copyEntry(srcId, this.container, this.idx());
    }

    @Override
    public String getTypeString() {
        return "ARRAY<" + this.reader.getTypeString() + '>';
    }
}

