/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.exec.expr.holders.IntervalHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.NullableIntervalVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class NullableIntervalWriterImpl
extends AbstractFieldWriter {
    private final NullableIntervalVector.Mutator mutator;
    final NullableIntervalVector vector;

    public NullableIntervalWriterImpl(NullableIntervalVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(IntervalHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableIntervalHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.mutator.setNull(this.idx());
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeInterval(int months, int days, int milliseconds) {
        this.mutator.setSafe(this.idx(), 1, months, days, milliseconds);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

