/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.BigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.BigIntWriter;

public class NullableBigIntHolderReaderImpl
extends AbstractFieldReader {
    private NullableBigIntHolder holder;

    public NullableBigIntHolderReaderImpl(NullableBigIntHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return NullableBigIntHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(BigIntHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableBigIntHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Long readLong() {
        if (!this.isSet()) {
            return null;
        }
        Long value = new Long(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        Long value = new Long(this.holder.value);
        return value;
    }

    @Override
    public void copyAsValue(BigIntWriter writer) {
        if (this.isSet()) {
            writer.writeBigInt(this.holder.value);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        BigIntWriter impl = writer.bigInt(name);
        if (this.isSet()) {
            impl.writeBigInt(this.holder.value);
        }
    }
}

