/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.Decimal38SparseVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class Decimal38SparseWriterImpl
extends AbstractFieldWriter {
    private final Decimal38SparseVector.Mutator mutator;
    final Decimal38SparseVector vector;

    public Decimal38SparseWriterImpl(Decimal38SparseVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(Decimal38SparseHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableDecimal38SparseHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDecimal38Sparse(int start, DrillBuf buffer, int precision, int scale) {
        this.mutator.setSafe(this.idx(), start, buffer);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

