/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.reader;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VariableWidthVector;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReaderIndex;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessor;
import oadd.org.apache.drill.exec.vector.complex.AbstractMapVector;
import oadd.org.apache.drill.exec.vector.complex.ListVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.UnionVector;

public class VectorAccessors {
    public static VectorAccessor arrayOffsetVectorAccessor(VectorAccessor repeatedAccessor) {
        if (repeatedAccessor.isHyper()) {
            return new ArrayOffsetHyperVectorAccessor(repeatedAccessor);
        }
        RepeatedValueVector vector = (RepeatedValueVector)repeatedAccessor.vector();
        return new SingleVectorAccessor(vector.getOffsetVector());
    }

    public static VectorAccessor arrayDataAccessor(VectorAccessor repeatedAccessor) {
        if (repeatedAccessor.isHyper()) {
            return new ArrayDataHyperVectorAccessor(repeatedAccessor);
        }
        RepeatedValueVector vector = (RepeatedValueVector)repeatedAccessor.vector();
        return new SingleVectorAccessor(vector.getDataVector());
    }

    public static VectorAccessor varWidthOffsetVectorAccessor(VectorAccessor varWidthAccessor) {
        if (varWidthAccessor.isHyper()) {
            return new VarWidthOffsetHyperVectorAccessor(varWidthAccessor);
        }
        VariableWidthVector vector = (VariableWidthVector)varWidthAccessor.vector();
        return new SingleVectorAccessor(vector.getOffsetVector());
    }

    public static VectorAccessor nullableValuesAccessor(VectorAccessor nullableAccessor) {
        if (nullableAccessor.isHyper()) {
            return new NullableValuesHyperVectorAccessor(nullableAccessor);
        }
        NullableVector vector = (NullableVector)nullableAccessor.vector();
        return new SingleVectorAccessor(vector.getValuesVector());
    }

    public static VectorAccessor nullableBitsAccessor(VectorAccessor nullableAccessor) {
        if (nullableAccessor.isHyper()) {
            return new NullableBitsHyperVectorStateReader(nullableAccessor);
        }
        NullableVector vector = (NullableVector)nullableAccessor.vector();
        return new SingleVectorAccessor(vector.getBitsVector());
    }

    public static VectorAccessor listBitsAccessor(VectorAccessor nullableAccessor) {
        if (nullableAccessor.isHyper()) {
            return new ListBitsHyperVectorStateReader(nullableAccessor);
        }
        ListVector vector = (ListVector)nullableAccessor.vector();
        return new SingleVectorAccessor(vector.getBitsVector());
    }

    public static class UnionMemberHyperVectorAccessor
    extends BaseHyperVectorAccessor {
        private final VectorAccessor unionVectorAccessor;
        private final TypeProtos.MinorType typeKey;

        public UnionMemberHyperVectorAccessor(VectorAccessor va, TypeProtos.MajorType type) {
            super(type);
            this.unionVectorAccessor = va;
            this.typeKey = type.getMinorType();
        }

        @Override
        public <T extends ValueVector> T vector() {
            UnionVector vector = (UnionVector)this.unionVectorAccessor.vector();
            return vector.member(this.typeKey);
        }
    }

    public static class UnionTypeHyperVectorAccessor
    extends BaseHyperVectorAccessor {
        private VectorAccessor unionVectorAccessor;

        public UnionTypeHyperVectorAccessor(VectorAccessor va) {
            super(Types.required(TypeProtos.MinorType.UINT1));
            this.unionVectorAccessor = va;
        }

        @Override
        public <T extends ValueVector> T vector() {
            UnionVector vector = (UnionVector)this.unionVectorAccessor.vector();
            return (T)vector.getTypeVector();
        }
    }

    public static class MapMemberHyperVectorAccessor
    extends BaseHyperVectorAccessor {
        private final VectorAccessor mapAccessor;
        private final int index;

        public MapMemberHyperVectorAccessor(VectorAccessor va, int index, TypeProtos.MajorType type) {
            super(type);
            this.mapAccessor = va;
            this.index = index;
        }

        @Override
        public <T extends ValueVector> T vector() {
            AbstractMapVector vector = (AbstractMapVector)this.mapAccessor.vector();
            return (T)vector.getChildByOrdinal(this.index);
        }
    }

    public static class ListMemberHyperVectorAccessor
    extends BaseHyperVectorAccessor {
        public final VectorAccessor listAccessor;

        public ListMemberHyperVectorAccessor(VectorAccessor listAccessor, TypeProtos.MajorType memberType) {
            super(memberType);
            this.listAccessor = listAccessor;
        }

        @Override
        public <T extends ValueVector> T vector() {
            ListVector vector = (ListVector)this.listAccessor.vector();
            return (T)vector.getDataVector();
        }
    }

    public static class ListBitsHyperVectorStateReader
    extends BaseHyperVectorAccessor {
        public final VectorAccessor listAccessor;

        public ListBitsHyperVectorStateReader(VectorAccessor listAccessor) {
            super(Types.required(TypeProtos.MinorType.UINT1));
            this.listAccessor = listAccessor;
        }

        @Override
        public <T extends ValueVector> T vector() {
            ListVector vector = (ListVector)this.listAccessor.vector();
            return (T)vector.getBitsVector();
        }
    }

    public static class NullableBitsHyperVectorStateReader
    extends BaseHyperVectorAccessor {
        public final VectorAccessor nullableAccessor;

        public NullableBitsHyperVectorStateReader(VectorAccessor nullableAccessor) {
            super(Types.required(TypeProtos.MinorType.UINT1));
            this.nullableAccessor = nullableAccessor;
        }

        @Override
        public <T extends ValueVector> T vector() {
            NullableVector vector = (NullableVector)this.nullableAccessor.vector();
            return (T)vector.getBitsVector();
        }
    }

    public static class NullableValuesHyperVectorAccessor
    implements VectorAccessor {
        private VectorAccessor nullableAccessor;

        private NullableValuesHyperVectorAccessor(VectorAccessor va) {
            this.nullableAccessor = va;
        }

        @Override
        public boolean isHyper() {
            return true;
        }

        @Override
        public TypeProtos.MajorType type() {
            return this.nullableAccessor.type();
        }

        @Override
        public void bind(ColumnReaderIndex index) {
        }

        @Override
        public <T extends ValueVector> T vector() {
            NullableVector vector = (NullableVector)this.nullableAccessor.vector();
            return (T)vector.getValuesVector();
        }
    }

    public static class VarWidthOffsetHyperVectorAccessor
    extends BaseHyperVectorAccessor {
        private VectorAccessor varWidthVectorAccessor;

        public VarWidthOffsetHyperVectorAccessor(VectorAccessor va) {
            super(Types.required(TypeProtos.MinorType.UINT4));
            this.varWidthVectorAccessor = va;
        }

        @Override
        public <T extends ValueVector> T vector() {
            VariableWidthVector vector = (VariableWidthVector)this.varWidthVectorAccessor.vector();
            return (T)vector.getOffsetVector();
        }
    }

    public static class ArrayDataHyperVectorAccessor
    implements VectorAccessor {
        private VectorAccessor repeatedVectorAccessor;

        private ArrayDataHyperVectorAccessor(VectorAccessor va) {
            this.repeatedVectorAccessor = va;
        }

        @Override
        public boolean isHyper() {
            return true;
        }

        @Override
        public TypeProtos.MajorType type() {
            return this.repeatedVectorAccessor.type();
        }

        @Override
        public void bind(ColumnReaderIndex index) {
        }

        @Override
        public <T extends ValueVector> T vector() {
            RepeatedValueVector vector = (RepeatedValueVector)this.repeatedVectorAccessor.vector();
            return (T)vector.getDataVector();
        }
    }

    public static class ArrayOffsetHyperVectorAccessor
    extends BaseHyperVectorAccessor {
        private VectorAccessor repeatedVectorAccessor;

        public ArrayOffsetHyperVectorAccessor(VectorAccessor va) {
            super(Types.required(TypeProtos.MinorType.UINT4));
            this.repeatedVectorAccessor = va;
        }

        @Override
        public <T extends ValueVector> T vector() {
            RepeatedValueVector vector = (RepeatedValueVector)this.repeatedVectorAccessor.vector();
            return (T)vector.getOffsetVector();
        }
    }

    public static abstract class BaseHyperVectorAccessor
    implements VectorAccessor {
        protected final TypeProtos.MajorType type;

        public BaseHyperVectorAccessor(TypeProtos.MajorType type) {
            this.type = type;
        }

        @Override
        public boolean isHyper() {
            return true;
        }

        @Override
        public void bind(ColumnReaderIndex index) {
        }

        @Override
        public TypeProtos.MajorType type() {
            return this.type;
        }
    }

    public static class SingleVectorAccessor
    implements VectorAccessor {
        private final ValueVector vector;

        public SingleVectorAccessor(ValueVector vector) {
            this.vector = vector;
        }

        @Override
        public boolean isHyper() {
            return false;
        }

        @Override
        public void bind(ColumnReaderIndex index) {
        }

        @Override
        public TypeProtos.MajorType type() {
            return this.vector.getField().getType();
        }

        @Override
        public <T extends ValueVector> T vector() {
            return (T)this.vector;
        }
    }

    public static class NullVectorAccesor
    implements VectorAccessor {
        private final TypeProtos.MajorType type;

        public NullVectorAccesor(TypeProtos.MajorType type) {
            this.type = type;
        }

        @Override
        public boolean isHyper() {
            return false;
        }

        @Override
        public TypeProtos.MajorType type() {
            return this.type;
        }

        @Override
        public void bind(ColumnReaderIndex index) {
        }

        @Override
        public <T extends ValueVector> T vector() {
            throw new UnsupportedOperationException();
        }
    }
}

