/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.convert;

import oadd.org.apache.drill.exec.vector.accessor.InvalidConversionError;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.convert.AbstractWriteConverter;
import oadd.org.joda.time.LocalDate;
import oadd.org.joda.time.format.DateTimeFormat;
import oadd.org.joda.time.format.DateTimeFormatter;
import oadd.org.joda.time.format.ISODateTimeFormat;

public class ConvertDateToString
extends AbstractWriteConverter {
    private final DateTimeFormatter dateTimeFormatter;

    public ConvertDateToString(ScalarWriter baseWriter) {
        super(baseWriter);
        String formatValue = baseWriter.schema().format();
        this.dateTimeFormatter = formatValue == null ? ISODateTimeFormat.date() : DateTimeFormat.forPattern(formatValue);
    }

    @Override
    public void setDate(LocalDate value) {
        if (value == null) {
            this.baseWriter.setNull();
        } else {
            try {
                this.baseWriter.setString(this.dateTimeFormatter.print(value));
            }
            catch (IllegalStateException e) {
                throw InvalidConversionError.writeError(this.schema(), value, e);
            }
        }
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setNull();
        } else {
            this.setDate((LocalDate)value);
        }
    }
}

