/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ssl;

import java.util.Properties;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.DrillConfigurationException;
import oadd.org.apache.drill.common.exceptions.DrillException;
import oadd.org.apache.drill.exec.ssl.SSLConfig;
import oadd.org.apache.drill.exec.ssl.SSLConfigClient;
import oadd.org.apache.drill.exec.ssl.SSLConfigServer;
import oadd.org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLConfigBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SSLConfigBuilder.class);
    private DrillConfig config = null;
    private Configuration hadoopConfig = null;
    private Properties properties;
    private SSLConfig.Mode mode = SSLConfig.Mode.SERVER;
    private boolean initializeSSLContext = false;
    private boolean validateKeyStore = false;

    public SSLConfig build() throws DrillException {
        if (this.mode == SSLConfig.Mode.SERVER && this.config == null) {
            throw new DrillConfigurationException("Cannot create SSL configuration from null Drill configuration.");
        }
        SSLConfig sslConfig = this.mode == SSLConfig.Mode.SERVER ? new SSLConfigServer(this.config, this.hadoopConfig) : new SSLConfigClient(this.properties);
        if (this.validateKeyStore) {
            sslConfig.validateKeyStore();
        }
        if (this.initializeSSLContext) {
            sslConfig.initContext();
        }
        return sslConfig;
    }

    public SSLConfigBuilder config(DrillConfig config) {
        this.config = config;
        return this;
    }

    public SSLConfigBuilder hadoopConfig(Configuration hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
        return this;
    }

    public SSLConfigBuilder properties(Properties props) {
        this.properties = props;
        return this;
    }

    public SSLConfigBuilder mode(SSLConfig.Mode mode) {
        this.mode = mode;
        return this;
    }

    public SSLConfigBuilder initializeSSLContext(boolean initializeSSLContext) {
        this.initializeSSLContext = initializeSSLContext;
        return this;
    }

    public SSLConfigBuilder validateKeyStore(boolean validateKeyStore) {
        this.validateKeyStore = validateKeyStore;
        return this;
    }
}

