/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import java.util.stream.Collectors;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleSchema;

public abstract class AbstractMapColumnMetadata
extends AbstractColumnMetadata {
    protected TupleMetadata parentTuple;
    protected final TupleSchema schema;

    public AbstractMapColumnMetadata(MaterializedField schema) {
        this(schema, null);
    }

    AbstractMapColumnMetadata(MaterializedField schema, TupleSchema mapSchema) {
        super(schema);
        this.schema = mapSchema == null ? new TupleSchema() : mapSchema;
        this.schema.bind(this);
    }

    public AbstractMapColumnMetadata(AbstractMapColumnMetadata from) {
        super(from);
        this.schema = (TupleSchema)from.schema.copy();
    }

    public AbstractMapColumnMetadata(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode, TupleSchema schema) {
        super(name, type, mode);
        this.schema = schema == null ? new TupleSchema() : schema;
    }

    @Override
    public void bind(TupleMetadata parentTuple) {
        this.parentTuple = parentTuple;
    }

    @Override
    public ColumnMetadata.StructureType structureType() {
        return ColumnMetadata.StructureType.TUPLE;
    }

    @Override
    public TupleMetadata mapSchema() {
        return this.schema;
    }

    @Override
    public int expectedWidth() {
        return 0;
    }

    public TupleMetadata parentTuple() {
        return this.parentTuple;
    }

    @Override
    public MaterializedField schema() {
        MaterializedField field = this.emptySchema();
        for (MaterializedField member : this.schema.toFieldList()) {
            field.addChild(member);
        }
        return field;
    }

    @Override
    public MaterializedField emptySchema() {
        return MaterializedField.create(this.name, TypeProtos.MajorType.newBuilder().setMinorType(this.type).setMode(this.mode).build());
    }

    @Override
    public String typeString() {
        StringBuilder builder = new StringBuilder();
        if (this.isArray()) {
            builder.append("ARRAY<");
        }
        builder.append(this.getStringType()).append("<").append(this.mapSchema().toMetadataList().stream().map(ColumnMetadata::columnString).collect(Collectors.joining(", "))).append(">");
        if (this.isArray()) {
            builder.append(">");
        }
        return builder.toString();
    }

    protected abstract String getStringType();
}

