/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.TypedFieldExpr;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.fn.FuncHolder;
import oadd.org.apache.drill.common.expression.fn.FunctionReplacementUtils;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.BooleanPredicate;
import oadd.org.apache.drill.exec.expr.ComparisonPredicate;
import oadd.org.apache.drill.exec.expr.DrillFuncHolderExpr;
import oadd.org.apache.drill.exec.expr.FilterPredicate;
import oadd.org.apache.drill.exec.expr.IsPredicate;
import oadd.org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;
import oadd.org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import oadd.org.apache.drill.exec.expr.fn.interpreter.InterpreterEvaluator;
import oadd.org.apache.drill.exec.expr.holders.BigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.BitHolder;
import oadd.org.apache.drill.exec.expr.holders.DateHolder;
import oadd.org.apache.drill.exec.expr.holders.Float4Holder;
import oadd.org.apache.drill.exec.expr.holders.Float8Holder;
import oadd.org.apache.drill.exec.expr.holders.IntHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.expr.holders.VarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.VarDecimalHolder;
import oadd.org.apache.drill.exec.ops.UdfUtilities;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterBuilder
extends AbstractExprVisitor<LogicalExpression, Set<LogicalExpression>, RuntimeException> {
    private static final Logger logger = LoggerFactory.getLogger(FilterBuilder.class);
    private final boolean omitUnsupportedExprs;
    private final UdfUtilities udfUtilities;
    private static final ImmutableSet<String> COMPARE_FUNCTIONS_SET;
    private static final ImmutableSet<String> IS_FUNCTIONS_SET;

    public static FilterPredicate buildFilterPredicate(LogicalExpression expr, Set<LogicalExpression> constantBoundaries, UdfUtilities udfUtilities, boolean omitUnsupportedExprs) {
        LogicalExpression logicalExpression = expr.accept(new FilterBuilder(udfUtilities, omitUnsupportedExprs), constantBoundaries);
        if (logicalExpression instanceof FilterPredicate) {
            return (FilterPredicate)((Object)logicalExpression);
        }
        if (logicalExpression instanceof TypedFieldExpr) {
            return (FilterPredicate)((Object)IsPredicate.createIsPredicate("istrue", logicalExpression));
        }
        logger.debug("Logical expression {} was not qualified for filter push down", (Object)logicalExpression);
        return null;
    }

    private FilterBuilder(UdfUtilities udfUtilities, boolean omitUnsupportedExprs) {
        this.udfUtilities = udfUtilities;
        this.omitUnsupportedExprs = omitUnsupportedExprs;
    }

    @Override
    public LogicalExpression visitUnknown(LogicalExpression e, Set<LogicalExpression> value) {
        return null;
    }

    @Override
    public LogicalExpression visitTypedFieldExpr(TypedFieldExpr typedFieldExpr, Set<LogicalExpression> value) {
        return typedFieldExpr;
    }

    @Override
    public LogicalExpression visitIntConstant(ValueExpressions.IntExpression intExpr, Set<LogicalExpression> value) {
        return intExpr;
    }

    @Override
    public LogicalExpression visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, Set<LogicalExpression> value) {
        return dExpr;
    }

    @Override
    public LogicalExpression visitFloatConstant(ValueExpressions.FloatExpression fExpr, Set<LogicalExpression> value) {
        return fExpr;
    }

    @Override
    public LogicalExpression visitLongConstant(ValueExpressions.LongExpression intExpr, Set<LogicalExpression> value) {
        return intExpr;
    }

    @Override
    public LogicalExpression visitVarDecimalConstant(ValueExpressions.VarDecimalExpression decExpr, Set<LogicalExpression> value) {
        return decExpr;
    }

    @Override
    public LogicalExpression visitDateConstant(ValueExpressions.DateExpression dateExpr, Set<LogicalExpression> value) {
        return dateExpr;
    }

    @Override
    public LogicalExpression visitTimeStampConstant(ValueExpressions.TimeStampExpression tsExpr, Set<LogicalExpression> value) {
        return tsExpr;
    }

    @Override
    public LogicalExpression visitTimeConstant(ValueExpressions.TimeExpression timeExpr, Set<LogicalExpression> value) {
        return timeExpr;
    }

    @Override
    public LogicalExpression visitBooleanConstant(ValueExpressions.BooleanExpression booleanExpression, Set<LogicalExpression> value) {
        return booleanExpression;
    }

    @Override
    public LogicalExpression visitQuotedStringConstant(ValueExpressions.QuotedString quotedString, Set<LogicalExpression> value) {
        return quotedString;
    }

    @Override
    public LogicalExpression visitBooleanOperator(BooleanOperator op, Set<LogicalExpression> value) {
        ArrayList<LogicalExpression> childPredicates = new ArrayList<LogicalExpression>();
        String functionName = op.getName();
        for (LogicalExpression arg : op.args) {
            LogicalExpression childPredicate = arg.accept(this, value);
            if (childPredicate == null) {
                if (!functionName.equals("booleanOr") && this.omitUnsupportedExprs) continue;
                return null;
            }
            if (childPredicate instanceof TypedFieldExpr) {
                childPredicate = IsPredicate.createIsPredicate("istrue", childPredicate);
            }
            childPredicates.add(childPredicate);
        }
        if (childPredicates.isEmpty()) {
            return null;
        }
        if (childPredicates.size() == 1) {
            return (LogicalExpression)childPredicates.get(0);
        }
        return BooleanPredicate.createBooleanPredicate(functionName, op.getName(), childPredicates, op.getPosition());
    }

    private LogicalExpression getValueExpressionFromConst(ValueHolder holder, TypeProtos.MinorType type) {
        switch (type) {
            case INT: {
                return ValueExpressions.getInt(((IntHolder)holder).value);
            }
            case BIGINT: {
                return ValueExpressions.getBigInt(((BigIntHolder)holder).value);
            }
            case FLOAT4: {
                return ValueExpressions.getFloat4(((Float4Holder)holder).value);
            }
            case FLOAT8: {
                return ValueExpressions.getFloat8(((Float8Holder)holder).value);
            }
            case VARDECIMAL: {
                VarDecimalHolder decimalHolder = (VarDecimalHolder)holder;
                return ValueExpressions.getVarDecimal(DecimalUtility.getBigDecimalFromDrillBuf(decimalHolder.buffer, decimalHolder.start, decimalHolder.end - decimalHolder.start, decimalHolder.scale), decimalHolder.precision, decimalHolder.scale);
            }
            case DATE: {
                return ValueExpressions.getDate(((DateHolder)holder).value);
            }
            case TIMESTAMP: {
                return ValueExpressions.getTimeStamp(((TimeStampHolder)holder).value);
            }
            case TIME: {
                return ValueExpressions.getTime(((TimeHolder)holder).value);
            }
            case BIT: {
                return ValueExpressions.getBit(((BitHolder)holder).value == 1);
            }
            case VARCHAR: {
                VarCharHolder varCharHolder = (VarCharHolder)holder;
                String value = StringFunctionHelpers.toStringFromUTF8((int)varCharHolder.start, (int)varCharHolder.end, (DrillBuf)varCharHolder.buffer);
                return ValueExpressions.getChar(value, value.length());
            }
        }
        return null;
    }

    @Override
    public LogicalExpression visitFunctionHolderExpression(FunctionHolderExpression funcHolderExpr, Set<LogicalExpression> value) {
        FuncHolder holder = funcHolderExpr.getHolder();
        if (!(holder instanceof DrillSimpleFuncHolder)) {
            return null;
        }
        if (value.contains(funcHolderExpr)) {
            ValueHolder result;
            try {
                result = InterpreterEvaluator.evaluateConstantExpr((UdfUtilities)this.udfUtilities, (LogicalExpression)funcHolderExpr);
            }
            catch (Exception e) {
                logger.warn("Error in evaluating function of {}", (Object)funcHolderExpr.getName());
                return null;
            }
            logger.debug("Reduce a constant function expression into a value expression");
            return this.getValueExpressionFromConst(result, funcHolderExpr.getMajorType().getMinorType());
        }
        String funcName = ((DrillSimpleFuncHolder)holder).getRegisteredNames()[0];
        if (FilterBuilder.isCompareFunction(funcName)) {
            return this.handleCompareFunction(funcHolderExpr, value);
        }
        if (FilterBuilder.isIsFunction(funcName) || this.isNot(funcHolderExpr, funcName)) {
            return this.handleIsFunction(funcHolderExpr, value);
        }
        if (FunctionReplacementUtils.isCastFunction(funcName)) {
            List<LogicalExpression> newArgs = this.generateNewExpressions(funcHolderExpr.args, value);
            if (newArgs == null) {
                return null;
            }
            return funcHolderExpr.copy(newArgs);
        }
        return null;
    }

    private boolean isNot(FunctionHolderExpression holderExpression, String funcName) {
        return !holderExpression.args.isEmpty() && !(holderExpression.args.get(0) instanceof DrillFuncHolderExpr) && "not".equals(funcName);
    }

    private List<LogicalExpression> generateNewExpressions(List<LogicalExpression> expressions, Set<LogicalExpression> value) {
        ArrayList<LogicalExpression> newExpressions = new ArrayList<LogicalExpression>();
        for (LogicalExpression arg : expressions) {
            LogicalExpression newArg = arg.accept(this, value);
            if (newArg == null) {
                return null;
            }
            newExpressions.add(newArg);
        }
        return newExpressions;
    }

    private LogicalExpression handleCompareFunction(FunctionHolderExpression functionHolderExpression, Set<LogicalExpression> value) {
        List<LogicalExpression> newArgs = this.generateNewExpressions(functionHolderExpression.args, value);
        if (newArgs == null) {
            return null;
        }
        String funcName = ((DrillSimpleFuncHolder)functionHolderExpression.getHolder()).getRegisteredNames()[0];
        return ComparisonPredicate.createComparisonPredicate(funcName, newArgs.get(0), newArgs.get(1));
    }

    private LogicalExpression handleIsFunction(FunctionHolderExpression functionHolderExpression, Set<LogicalExpression> value) {
        if (!(functionHolderExpression.getHolder() instanceof DrillSimpleFuncHolder)) {
            logger.warn("Can not cast {} to DrillSimpleFuncHolder. Metadata filter pushdown can not handle function.", (Object)functionHolderExpression.getHolder());
            return null;
        }
        String funcName = ((DrillSimpleFuncHolder)functionHolderExpression.getHolder()).getRegisteredNames()[0];
        LogicalExpression arg = (LogicalExpression)functionHolderExpression.args.get(0);
        return IsPredicate.createIsPredicate(funcName, arg.accept(this, value));
    }

    private static boolean isCompareFunction(String funcName) {
        return COMPARE_FUNCTIONS_SET.contains(funcName);
    }

    private static boolean isIsFunction(String funcName) {
        return IS_FUNCTIONS_SET.contains(funcName);
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        COMPARE_FUNCTIONS_SET = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)builder.add("equal")).add("greater_than")).add("greater_than_or_equal_to")).add("less_than")).add("less_than_or_equal_to")).add("not_equal")).build();
        builder = ImmutableSet.builder();
        IS_FUNCTIONS_SET = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)builder.add("isnull")).add("isnotnull")).add("istrue")).add("isnottrue")).add("isfalse")).add("isnotfalse")).build();
    }
}

