/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.util;

import oadd.javassist.CannotCompileException;
import oadd.javassist.ClassPool;
import oadd.javassist.CtClass;
import oadd.javassist.CtMethod;
import oadd.javassist.CtNewConstructor;
import oadd.javassist.CtNewMethod;
import oadd.javassist.Modifier;
import oadd.javassist.scopedpool.ScopedClassPoolRepository;
import oadd.javassist.scopedpool.ScopedClassPoolRepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufPatcher {
    private static final Logger logger = LoggerFactory.getLogger(ProtobufPatcher.class);
    private static boolean patchingAttempted = false;

    public static synchronized void patch() {
        if (!patchingAttempted) {
            patchingAttempted = true;
            ProtobufPatcher.patchByteString();
            ProtobufPatcher.patchGeneratedMessageLite();
            ProtobufPatcher.patchGeneratedMessageLiteBuilder();
        }
    }

    private static void patchByteString() {
        try {
            ClassPool classPool = ProtobufPatcher.getClassPool();
            CtClass byteString = classPool.get("oadd.com.google.protobuf.ByteString");
            ProtobufPatcher.removeFinal(byteString.getDeclaredMethod("toString"));
            ProtobufPatcher.removeFinal(byteString.getDeclaredMethod("hashCode"));
            ProtobufPatcher.removeFinal(byteString.getDeclaredMethod("iterator"));
            CtClass googleLiteralByteString = classPool.get("oadd.com.google.protobuf.ByteString$LiteralByteString");
            ProtobufPatcher.removePrivate(googleLiteralByteString);
            CtClass googleBoundedByteString = classPool.get("oadd.com.google.protobuf.ByteString$BoundedByteString");
            ProtobufPatcher.removePrivate(googleBoundedByteString);
            ProtobufPatcher.removeFinal(googleBoundedByteString);
            for (CtMethod ctMethod : googleLiteralByteString.getDeclaredMethods()) {
                ProtobufPatcher.removeFinal(ctMethod);
            }
            byteString.toClass();
            googleLiteralByteString.toClass();
            googleBoundedByteString.toClass();
            CtClass literalByteString = classPool.makeClass("oadd.com.google.protobuf.LiteralByteString");
            literalByteString.setSuperclass(googleLiteralByteString);
            literalByteString.toClass();
            CtClass boundedByteString = classPool.makeClass("oadd.com.google.protobuf.BoundedByteString");
            boundedByteString.setSuperclass(googleBoundedByteString);
            boundedByteString.toClass();
        }
        catch (Exception e) {
            logger.warn("Unable to patch Protobuf.", e);
        }
    }

    private static void patchGeneratedMessageLite() {
        try {
            ClassPool classPool = ProtobufPatcher.getClassPool();
            CtClass generatedMessageLite = classPool.get("oadd.com.google.protobuf.GeneratedMessageLite");
            ProtobufPatcher.removeFinal(generatedMessageLite.getDeclaredMethod("getParserForType"));
            ProtobufPatcher.removeFinal(generatedMessageLite.getDeclaredMethod("isInitialized"));
            generatedMessageLite.addMethod(CtNewMethod.make("protected void makeExtensionsImmutable() { }", generatedMessageLite));
            String className = "oadd.com.google.protobuf.GeneratedMessageLite.Builder";
            generatedMessageLite.addConstructor(CtNewConstructor.make("protected GeneratedMessageLite(" + className + " builder) { }", generatedMessageLite));
            CtMethod dynamicMethod = generatedMessageLite.getDeclaredMethod("dynamicMethod", new CtClass[]{classPool.get("oadd.com.google.protobuf.GeneratedMessageLite$MethodToInvoke"), classPool.get("java.lang.Object"), classPool.get("java.lang.Object")});
            className = "oadd.com.google.protobuf.GeneratedMessageLite.MethodToInvoke";
            ProtobufPatcher.addImplementation(dynamicMethod, "if ($1.equals(" + className + ".GET_DEFAULT_INSTANCE)) {  return this;} else {  return null;}");
            generatedMessageLite.toClass();
        }
        catch (Exception e) {
            logger.warn("Unable to patch Protobuf.", e);
        }
    }

    private static void patchGeneratedMessageLiteBuilder() {
        try {
            ClassPool classPool = ProtobufPatcher.getClassPool();
            CtClass builder = classPool.get("oadd.com.google.protobuf.GeneratedMessageLite$Builder");
            ProtobufPatcher.removeFinal(builder.getDeclaredMethod("isInitialized"));
            ProtobufPatcher.removeFinal(builder.getDeclaredMethod("clear"));
            builder.addConstructor(CtNewConstructor.defaultConstructor(builder));
            builder.toClass();
        }
        catch (Exception e) {
            logger.warn("Unable to patch Protobuf.", e);
        }
    }

    private static void removeFinal(CtMethod ctMethod) {
        int modifiers = Modifier.clear(ctMethod.getModifiers(), 16);
        ctMethod.setModifiers(modifiers);
    }

    private static void removeFinal(CtClass ctClass) {
        int modifiers = Modifier.clear(ctClass.getModifiers(), 16);
        ctClass.setModifiers(modifiers);
    }

    private static void removePrivate(CtClass ctClass) {
        int modifiers = Modifier.clear(ctClass.getModifiers(), 2);
        ctClass.setModifiers(modifiers);
    }

    private static void addImplementation(CtMethod ctMethod, String methodBody) throws CannotCompileException {
        ctMethod.setBody(methodBody);
        int modifiers = Modifier.clear(ctMethod.getModifiers(), 1024);
        ctMethod.setModifiers(modifiers);
    }

    private static ClassPool getClassPool() {
        ScopedClassPoolRepository classPoolRepository = ScopedClassPoolRepositoryImpl.getInstance();
        classPoolRepository.setPrune(false);
        return classPoolRepository.createScopedClassPool(ProtobufPatcher.class.getClassLoader(), null);
    }
}

