/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.util;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import oadd.org.apache.commons.lang3.StringUtils;
import oadd.org.apache.drill.exec.proto.UserBitShared;

public class DrillExceptionUtil {
    public static Throwable getThrowable(UserBitShared.ExceptionWrapper exceptionWrapper) {
        if (exceptionWrapper == null) {
            return null;
        }
        String className = exceptionWrapper.getExceptionClass();
        if (StringUtils.isBlank(className) || exceptionWrapper.getStackTraceCount() < 1) {
            return null;
        }
        Throwable inner = DrillExceptionUtil.getThrowable(exceptionWrapper.getCause());
        try {
            Throwable throwable = DrillExceptionUtil.getInstance(className, exceptionWrapper.getMessage(), inner);
            int size = exceptionWrapper.getStackTraceCount();
            StackTraceElement[] stackTrace = new StackTraceElement[size];
            for (int i = 0; i < size; ++i) {
                UserBitShared.StackTraceElementWrapper w = exceptionWrapper.getStackTrace(i);
                stackTrace[i] = new StackTraceElement(w.getClassName(), w.getMethodName(), w.getFileName(), w.getLineNumber());
            }
            throwable.setStackTrace(stackTrace);
            return throwable;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Throwable getInstance(String className, String message, Throwable inner) throws ReflectiveOperationException {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return new Exception(message, inner);
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        Object[] defaultParameterTypes = new Class[]{String.class, Throwable.class};
        Object[] revertParameterTypes = new Class[]{Throwable.class, String.class};
        Object[] singleParameterType = new Class[]{String.class};
        for (Constructor<?> constructor : constructors) {
            if (Arrays.equals(defaultParameterTypes, constructor.getParameterTypes())) {
                return (Throwable)constructor.newInstance(message, inner);
            }
            if (Arrays.equals(revertParameterTypes, constructor.getParameterTypes())) {
                return (Throwable)constructor.newInstance(inner, message);
            }
            if (inner != null || !Arrays.equals(singleParameterType, constructor.getParameterTypes())) continue;
            return (Throwable)constructor.newInstance(message);
        }
        return DrillExceptionUtil.getBaseInstance(clazz, message, inner);
    }

    private static Throwable getBaseInstance(Class clazz, String message, Throwable inner) {
        if (Error.class.isAssignableFrom(clazz)) {
            return new Error(message, inner);
        }
        return new Exception(message, inner);
    }
}

