/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KerberosUtil {
    private static final Logger logger = LoggerFactory.getLogger(KerberosUtil.class);
    public static final String KERBEROS_SASL_NAME = "GSSAPI";
    public static final String KERBEROS_SIMPLE_NAME = "KERBEROS";
    public static final String HOSTNAME_PATTERN = "_HOST";

    public static String getPrincipalFromParts(String primary, String instance, String realm) {
        Preconditions.checkNotNull(primary);
        Preconditions.checkNotNull(realm);
        return primary + (instance != "" ? "/" + instance : "") + "@" + realm;
    }

    public static String[] splitPrincipalIntoParts(String principal) {
        String[] components = principal.split("[/@]");
        Preconditions.checkState(components.length < 4);
        Preconditions.checkState(components.length > 1);
        Preconditions.checkNotNull(components[0]);
        Preconditions.checkNotNull(components[1]);
        if (components.length == 2) {
            return new String[]{components[0], "", components[1]};
        }
        Preconditions.checkNotNull(components[2]);
        return components;
    }

    public static String canonicalizeInstanceName(String instanceName, String canonicalName) {
        String lowercaseName;
        if (instanceName == null || HOSTNAME_PATTERN.equalsIgnoreCase(instanceName)) {
            instanceName = canonicalName;
        }
        if (!instanceName.equals(lowercaseName = instanceName.toLowerCase())) {
            logger.warn("Converting service name ({}) to lowercase, see HADOOP-7988.", (Object)instanceName);
        }
        return lowercaseName;
    }

    public static String getDefaultRealm() throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> classRef = System.getProperty("java.vendor").contains("IBM") ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
        Method getInstanceMethod = classRef.getMethod("getInstance", new Class[0]);
        Object kerbConf = getInstanceMethod.invoke(classRef, new Object[0]);
        Method getDefaultRealmMethod = classRef.getDeclaredMethod("getDefaultRealm", new Class[0]);
        return (String)getDefaultRealmMethod.invoke(kerbConf, new Object[0]);
    }

    private KerberosUtil() {
    }
}

