/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.loader.api;

import com.github.dozermapper.core.classmap.MappingDirection;
import com.github.dozermapper.core.loader.DozerBuilder;
import com.github.dozermapper.core.loader.api.FieldDefinition;
import com.github.dozermapper.core.loader.api.FieldsMappingOption;

public final class TypeMappingBuilder {
    private DozerBuilder.MappingBuilder beanMappingBuilder;

    public TypeMappingBuilder(DozerBuilder.MappingBuilder beanMappingBuilder) {
        this.beanMappingBuilder = beanMappingBuilder;
    }

    public TypeMappingBuilder fields(String a, String b, FieldsMappingOption ... options) {
        return this.fields(new FieldDefinition(a), new FieldDefinition(b), options);
    }

    public TypeMappingBuilder fields(FieldDefinition a, String b, FieldsMappingOption ... options) {
        return this.fields(a, new FieldDefinition(b), options);
    }

    public TypeMappingBuilder fields(String a, FieldDefinition b, FieldsMappingOption ... options) {
        return this.fields(new FieldDefinition(a), b, options);
    }

    public TypeMappingBuilder fields(FieldDefinition a, FieldDefinition b, FieldsMappingOption ... options) {
        DozerBuilder.FieldMappingBuilder builder = this.beanMappingBuilder.field();
        String aText = a.resolve();
        String bText = b.resolve();
        a.build(builder.a(aText));
        b.build(builder.b(bText));
        for (FieldsMappingOption option : options) {
            option.apply(builder);
        }
        return this;
    }

    public TypeMappingBuilder exclude(String field) {
        return this.exclude(new FieldDefinition(field), MappingDirection.BI_DIRECTIONAL);
    }

    public TypeMappingBuilder exclude(String field, MappingDirection direction) {
        return this.exclude(new FieldDefinition(field), direction);
    }

    public TypeMappingBuilder exclude(FieldDefinition field) {
        return this.exclude(field, MappingDirection.BI_DIRECTIONAL);
    }

    public TypeMappingBuilder exclude(FieldDefinition field, MappingDirection direction) {
        DozerBuilder.FieldExclusionBuilder builder = this.beanMappingBuilder.fieldExclude();
        builder.a(field.resolve(), null);
        builder.b(field.resolve(), null);
        builder.type(direction);
        return this;
    }
}

