/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.dozer;

import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.core.classmap.MappingDirection;
import com.github.dozermapper.core.metadata.ClassMappingMetadata;
import com.github.dozermapper.core.metadata.MappingMetadata;
import com.github.dozermapper.core.util.DozerClassLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.dozer.DozerBeanMapperConfiguration;
import org.apache.camel.converter.dozer.DozerTypeConverter;
import org.apache.camel.converter.dozer.MapperFactory;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DozerTypeConverterLoader
extends ServiceSupport
implements CamelContextAware {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private CamelContext camelContext;
    private transient DozerBeanMapperConfiguration configuration;
    private transient Mapper mapper;

    public DozerTypeConverterLoader() {
    }

    public DozerTypeConverterLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
        try {
            camelContext.addService((Object)this);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public DozerTypeConverterLoader(CamelContext camelContext, DozerBeanMapperConfiguration configuration) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader appcl = camelContext.getApplicationContextClassLoader();
            if (appcl != null) {
                Thread.currentThread().setContextClassLoader(appcl);
            }
            this.log.info("Using DozerBeanMapperConfiguration: {}", (Object)configuration);
            MapperFactory factory = new MapperFactory(camelContext, configuration);
            Mapper mapper = factory.create();
            this.camelContext = camelContext;
            this.mapper = mapper;
            this.configuration = configuration;
            camelContext.addService((Object)this);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CamelContext camelContext, Mapper mapper) {
        this.camelContext = camelContext;
        if (mapper != null) {
            this.mapper = mapper;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Map<String, DozerBeanMapperConfiguration> configurations;
            ClassLoader appcl = camelContext.getApplicationContextClassLoader();
            if (appcl != null) {
                Thread.currentThread().setContextClassLoader(appcl);
            }
            Map<String, Mapper> mappers = this.lookupDozerBeanMappers();
            if (mapper != null && !mappers.containsValue(mapper)) {
                mappers.put("parameter", mapper);
            }
            if ((configurations = this.lookupDozerBeanMapperConfigurations()) != null && this.configuration != null) {
                Object key = null;
                for (Map.Entry<String, DozerBeanMapperConfiguration> entry : configurations.entrySet()) {
                    if (entry.getValue() != this.configuration) continue;
                    key = entry.getKey();
                    break;
                }
                if (key != null) {
                    configurations.remove(key);
                }
            }
            if (configurations != null) {
                for (Map.Entry<String, DozerBeanMapperConfiguration> entry : configurations.entrySet()) {
                    String string = entry.getKey();
                    MapperFactory factory = new MapperFactory(this.getCamelContext(), entry.getValue());
                    Mapper beanMapper = factory.create();
                    if (mappers.containsValue(beanMapper)) continue;
                    mappers.put(string, beanMapper);
                }
            }
            this.log.info("Loaded {} Dozer mappers from Camel registry.", (Object)mappers.size());
            if (mappers.size() == 0) {
                this.log.warn("No Dozer mappers found in Camel registry. You should add Dozer mappers as beans to the registry of the type: {}", (Object)Mapper.class.getName());
            }
            TypeConverterRegistry registry = camelContext.getTypeConverterRegistry();
            for (Map.Entry<String, DozerBeanMapperConfiguration> entry : mappers.entrySet()) {
                String mapperId = entry.getKey();
                Mapper dozer = (Mapper)entry.getValue();
                MappingMetadata meta = dozer.getMappingMetadata();
                List all = meta.getClassMappings();
                this.registerClassMaps(registry, mapperId, dozer, all);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    protected Map<String, Mapper> lookupDozerBeanMappers() {
        return new HashMap<String, Mapper>(this.camelContext.getRegistry().findByTypeWithName(Mapper.class));
    }

    protected Map<String, DozerBeanMapperConfiguration> lookupDozerBeanMapperConfigurations() {
        return new HashMap<String, DozerBeanMapperConfiguration>(this.camelContext.getRegistry().findByTypeWithName(DozerBeanMapperConfiguration.class));
    }

    protected void registerClassMaps(TypeConverterRegistry registry, String dozerId, Mapper dozer, List<ClassMappingMetadata> all) {
        DozerTypeConverter converter = new DozerTypeConverter(dozer);
        for (ClassMappingMetadata map : all) {
            this.addDozerTypeConverter(registry, converter, dozerId, map.getSourceClass(), map.getDestinationClass());
            if (map.getMappingDirection() == MappingDirection.ONE_WAY) continue;
            this.addDozerTypeConverter(registry, converter, dozerId, map.getDestinationClass(), map.getSourceClass());
        }
    }

    protected void addDozerTypeConverter(TypeConverterRegistry registry, DozerTypeConverter converter, String dozerId, Class<?> to, Class<?> from) {
        if (this.log.isInfoEnabled()) {
            if (dozerId != null) {
                this.log.info("Added Dozer: {} as Camel type converter: {} -> {}", new Object[]{dozerId, from, to});
            } else {
                this.log.info("Added Dozer as Camel type converter: {} -> {}", new Object[]{from, to});
            }
        }
        registry.addTypeConverter(from, to, (TypeConverter)converter);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        if (this.camelContext == null) {
            this.camelContext = camelContext;
            try {
                camelContext.addService((Object)this);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    protected static URL loadMappingFile(ClassResolver classResolver, String mappingFile) {
        URL url = null;
        try {
            url = ResourceHelper.resolveResourceAsUrl((ClassResolver)classResolver, (String)mappingFile);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null) {
            url = DozerClassLoader.class.getClassLoader().getResource(mappingFile);
        }
        return url;
    }

    protected void doStart() throws Exception {
        this.init(this.camelContext, this.mapper);
    }

    protected void doStop() throws Exception {
    }
}

