/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Message;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.utils.base64;

public final class DohResolver
implements Resolver {
    private static final Logger log = LoggerFactory.getLogger(DohResolver.class);
    private static final boolean useHttpClient;
    private static Object defaultHttpRequestBuilder;
    private static Method publisherOfByteArrayMethod;
    private static Method requestBuilderTimeoutMethod;
    private static Method requestBuilderCopyMethod;
    private static Method requestBuilderUriMethod;
    private static Method requestBuilderBuildMethod;
    private static Method requestBuilderPostMethod;
    private static Method httpClientNewBuilderMethod;
    private static Method httpClientBuilderTimeoutMethod;
    private static Method httpClientBuilderBuildMethod;
    private static Method httpClientSendAsyncMethod;
    private static Method byteArrayBodyPublisherMethod;
    private static Method httpResponseBodyMethod;
    private static Method httpResponseStatusCodeMethod;
    private boolean usePost = false;
    private Duration timeout = Duration.ofSeconds(5L);
    private String uriTemplate;
    private OPTRecord queryOPT = new OPTRecord(0, 0, 0);
    private TSIG tsig;
    private Object httpClient;

    public DohResolver(String uriTemplate) {
        this.uriTemplate = uriTemplate;
        this.buildHttpClient();
    }

    private void buildHttpClient() {
        if (useHttpClient) {
            Object httpClientBuilder = httpClientNewBuilderMethod.invoke(null, new Object[0]);
            httpClientBuilderTimeoutMethod.invoke(httpClientBuilder, this.timeout);
            this.httpClient = httpClientBuilderBuildMethod.invoke(httpClientBuilder, new Object[0]);
            requestBuilderTimeoutMethod.invoke(defaultHttpRequestBuilder, this.timeout);
        }
    }

    @Override
    public void setPort(int port) {
    }

    @Override
    public void setTCP(boolean flag) {
    }

    @Override
    public void setIgnoreTruncation(boolean flag) {
    }

    @Override
    public void setEDNS(int version, int payloadSize, int flags, List<EDNSOption> options) {
        switch (version) {
            case -1: {
                this.queryOPT = null;
                break;
            }
            case 0: {
                this.queryOPT = new OPTRecord(0, 0, version, flags, options);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid EDNS version - must be 0 or -1 to disable");
            }
        }
    }

    @Override
    public void setTSIGKey(TSIG key) {
        this.tsig = key;
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
        this.buildHttpClient();
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public CompletionStage<Message> sendAsync(Message query) {
        if (useHttpClient) {
            return this.sendAsync11(query);
        }
        return this.sendAsync8(query);
    }

    private CompletionStage<Message> sendAsync8(Message query) {
        CompletableFuture<Message> f = new CompletableFuture<Message>();
        ForkJoinPool.commonPool().execute(() -> {
            try {
                byte[] queryBytes = this.prepareQuery(query).toWire();
                String url = this.getUrl(queryBytes);
                byte[] responseBytes = this.sendAndGetMessageBytes(url, queryBytes);
                Message response = new Message(responseBytes);
                this.verifyTSIG(query, response, responseBytes, this.tsig);
                response.setResolver(this);
                f.complete(response);
            }
            catch (IOException e) {
                f.completeExceptionally(e);
            }
        });
        return f;
    }

    private byte[] sendAndGetMessageBytes(String url, byte[] queryBytes) throws IOException {
        int r;
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setConnectTimeout((int)this.timeout.toMillis());
        conn.setRequestMethod(this.isUsePost() ? "POST" : "GET");
        conn.setRequestProperty("Content-Type", "application/dns-message");
        conn.setRequestProperty("Accept", "application/dns-message");
        if (this.usePost) {
            conn.setDoOutput(true);
            conn.getOutputStream().write(queryBytes);
        }
        InputStream is = conn.getInputStream();
        byte[] responseBytes = new byte[conn.getContentLength()];
        int offset = 0;
        while ((r = is.read(responseBytes, offset, responseBytes.length)) > 0) {
            offset += r;
        }
        return responseBytes;
    }

    private CompletionStage<Message> sendAsync11(Message query) {
        byte[] queryBytes = this.prepareQuery(query).toWire();
        String url = this.getUrl(queryBytes);
        try {
            Object builder = requestBuilderCopyMethod.invoke(defaultHttpRequestBuilder, new Object[0]);
            requestBuilderUriMethod.invoke(builder, URI.create(url));
            if (this.usePost) {
                requestBuilderPostMethod.invoke(builder, publisherOfByteArrayMethod.invoke(null, new Object[]{queryBytes}));
            }
            Object httpRequest = requestBuilderBuildMethod.invoke(builder, new Object[0]);
            Object bodyHandler = byteArrayBodyPublisherMethod.invoke(null, new Object[0]);
            return ((CompletionStage)httpClientSendAsyncMethod.invoke(this.httpClient, httpRequest, bodyHandler)).thenComposeAsync(response -> {
                try {
                    Message responseMessage;
                    if ((Integer)httpResponseStatusCodeMethod.invoke(response, new Object[0]) == 200) {
                        byte[] responseBytes = (byte[])httpResponseBodyMethod.invoke(response, new Object[0]);
                        responseMessage = new Message(responseBytes);
                        this.verifyTSIG(query, responseMessage, responseBytes, this.tsig);
                    } else {
                        responseMessage = new Message();
                        responseMessage.getHeader().setRcode(2);
                    }
                    responseMessage.setResolver(this);
                    return CompletableFuture.completedFuture(responseMessage);
                }
                catch (IOException | IllegalAccessException | InvocationTargetException e) {
                    return this.failedFuture(e);
                }
            });
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return this.failedFuture(e);
        }
    }

    private <T> CompletionStage<T> failedFuture(Throwable e) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(e);
        return f;
    }

    private String getUrl(byte[] queryBytes) {
        String url = this.uriTemplate;
        if (!this.usePost) {
            url = url + "?dns=" + base64.toString(queryBytes, true);
        }
        return url;
    }

    private Message prepareQuery(Message query) {
        Message preparedQuery = query.clone();
        preparedQuery.getHeader().setID(0);
        if (this.queryOPT != null && preparedQuery.getOPT() == null) {
            preparedQuery.addRecord(this.queryOPT, 3);
        }
        if (this.tsig != null) {
            this.tsig.apply(preparedQuery, null);
        }
        return preparedQuery;
    }

    private void verifyTSIG(Message query, Message response, byte[] b, TSIG tsig) {
        if (tsig == null) {
            return;
        }
        int error = tsig.verify(response, b, query.getTSIG());
        log.debug("TSIG verify: {}", (Object)Rcode.TSIGstring(error));
    }

    public boolean isUsePost() {
        return this.usePost;
    }

    public void setUsePost(boolean usePost) {
        this.usePost = usePost;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public String toString() {
        return "DohResolver {" + (this.usePost ? "POST " : "GET ") + this.uriTemplate + "}";
    }

    static {
        boolean initSuccess = false;
        if (!System.getProperty("java.version").startsWith("1.")) {
            try {
                Class<?> httpClientBuilderClass = Class.forName("java.net.http.HttpClient$Builder");
                Class<?> httpClientClass = Class.forName("java.net.http.HttpClient");
                Class<?> httpVersionEnum = Class.forName("java.net.http.HttpClient$Version");
                Class<?> httpRequestBuilderClass = Class.forName("java.net.http.HttpRequest$Builder");
                Class<?> httpRequestClass = Class.forName("java.net.http.HttpRequest");
                Class<?> bodyPublishersClass = Class.forName("java.net.http.HttpRequest$BodyPublishers");
                Class<?> bodyPublisherClass = Class.forName("java.net.http.HttpRequest$BodyPublisher");
                Class<?> httpResponseClass = Class.forName("java.net.http.HttpResponse");
                Class<?> bodyHandlersClass = Class.forName("java.net.http.HttpResponse$BodyHandlers");
                Class<?> bodyHandlerClass = Class.forName("java.net.http.HttpResponse$BodyHandler");
                httpClientBuilderTimeoutMethod = httpClientBuilderClass.getDeclaredMethod("connectTimeout", Duration.class);
                httpClientBuilderBuildMethod = httpClientBuilderClass.getDeclaredMethod("build", new Class[0]);
                httpClientNewBuilderMethod = httpClientClass.getDeclaredMethod("newBuilder", new Class[0]);
                httpClientSendAsyncMethod = httpClientClass.getDeclaredMethod("sendAsync", httpRequestClass, bodyHandlerClass);
                Method requestBuilderHeaderMethod = httpRequestBuilderClass.getDeclaredMethod("header", String.class, String.class);
                Method requestBuilderVersionMethod = httpRequestBuilderClass.getDeclaredMethod("version", httpVersionEnum);
                requestBuilderTimeoutMethod = httpRequestBuilderClass.getDeclaredMethod("timeout", Duration.class);
                requestBuilderUriMethod = httpRequestBuilderClass.getDeclaredMethod("uri", URI.class);
                requestBuilderCopyMethod = httpRequestBuilderClass.getDeclaredMethod("copy", new Class[0]);
                requestBuilderBuildMethod = httpRequestBuilderClass.getDeclaredMethod("build", new Class[0]);
                requestBuilderPostMethod = httpRequestBuilderClass.getDeclaredMethod("POST", bodyPublisherClass);
                Method requestBuilderNewBuilderMethod = httpRequestClass.getDeclaredMethod("newBuilder", new Class[0]);
                publisherOfByteArrayMethod = bodyPublishersClass.getDeclaredMethod("ofByteArray", byte[].class);
                byteArrayBodyPublisherMethod = bodyHandlersClass.getDeclaredMethod("ofByteArray", new Class[0]);
                httpResponseBodyMethod = httpResponseClass.getDeclaredMethod("body", new Class[0]);
                httpResponseStatusCodeMethod = httpResponseClass.getDeclaredMethod("statusCode", new Class[0]);
                defaultHttpRequestBuilder = requestBuilderNewBuilderMethod.invoke(null, new Object[0]);
                Object http2Version = Enum.valueOf(httpVersionEnum, "HTTP_2");
                requestBuilderVersionMethod.invoke(defaultHttpRequestBuilder, http2Version);
                requestBuilderHeaderMethod.invoke(defaultHttpRequestBuilder, "Content-Type", "application/dns-message");
                requestBuilderHeaderMethod.invoke(defaultHttpRequestBuilder, "Accept", "application/dns-message");
                initSuccess = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Java >= 11 detected, but HttpRequest not available");
            }
        }
        useHttpClient = initSuccess;
    }
}

