/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.dns.DnsDigProducer;
import org.apache.camel.component.dns.DnsIpProducer;
import org.apache.camel.component.dns.DnsLookupProducer;
import org.apache.camel.component.dns.DnsType;
import org.apache.camel.component.dns.DnsWikipediaProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.7.0", scheme="dns", title="DNS", syntax="dns:dnsType", producerOnly=true, category={Category.NETWORKING})
public class DnsEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private DnsType dnsType;

    public DnsEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Producer createProducer() throws Exception {
        if (DnsType.dig == this.dnsType) {
            return new DnsDigProducer((Endpoint)this);
        }
        if (DnsType.ip == this.dnsType) {
            return new DnsIpProducer((Endpoint)this);
        }
        if (DnsType.lookup == this.dnsType) {
            return new DnsLookupProducer((Endpoint)this);
        }
        if (DnsType.wikipedia == this.dnsType) {
            return new DnsWikipediaProducer((Endpoint)this);
        }
        return null;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public DnsType getDnsType() {
        return this.dnsType;
    }

    public void setDnsType(DnsType dnsType) {
        this.dnsType = dnsType;
    }
}

