/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.config;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import org.xbill.DNS.config.BaseResolverConfigProvider;

public class PropertyResolverConfigProvider
extends BaseResolverConfigProvider {
    public static final String DNS_SERVER_PROP = "dns.server";
    public static final String DNS_SEARCH_PROP = "dns.search";
    public static final String DNS_NDOTS_PROP = "dns.ndots";
    private int ndots;

    @Override
    public void initialize() {
        String servers = System.getProperty(DNS_SERVER_PROP);
        if (servers != null) {
            StringTokenizer st = new StringTokenizer(servers, ",");
            while (st.hasMoreTokens()) {
                String server = st.nextToken();
                try {
                    URI uri = new URI("dns://" + server);
                    if (uri.getHost() == null) {
                        this.addNameserver(new InetSocketAddress(server, 53));
                        continue;
                    }
                    int port = uri.getPort();
                    if (port == -1) {
                        port = 53;
                    }
                    this.addNameserver(new InetSocketAddress(uri.getHost(), port));
                }
                catch (URISyntaxException e) {
                    this.log.warn("Ignored invalid server {}", (Object)server);
                }
            }
        }
        String searchPathProperty = System.getProperty(DNS_SEARCH_PROP);
        this.parseSearchPathList(searchPathProperty, ",");
        String ndotsProperty = System.getProperty(DNS_NDOTS_PROP);
        this.ndots = this.parseNdots(ndotsProperty);
    }

    @Override
    public int ndots() {
        return this.ndots;
    }
}

