/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class NDSerializer {
    static final int BUFFER_SIZE = 81920;
    static final String MAGIC_NUMBER = "NDAR";
    static final int VERSION = 1;

    private NDSerializer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] encode(NDArray array) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(MAGIC_NUMBER);
            dos.writeInt(1);
            dos.writeUTF(array.getSparseFormat().name());
            dos.writeUTF(array.getDataType().name());
            Shape shape = array.getShape();
            dos.write(shape.getEncoded());
            ByteBuffer bb = array.toByteBuffer();
            int length = bb.remaining();
            dos.writeInt(length);
            if (length > 0) {
                byte[] buf;
                if (length > 81920) {
                    buf = new byte[81920];
                    while (length > 81920) {
                        bb.get(buf);
                        dos.write(buf);
                        length = bb.remaining();
                    }
                }
                buf = new byte[length];
                bb.get(buf);
                dos.write(buf);
            }
            dos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new AssertionError("This should never happen", e);
        }
    }

    static NDArray decode(NDManager manager, InputStream is) throws IOException {
        int length;
        DataInputStream dis = is instanceof DataInputStream ? (DataInputStream)is : new DataInputStream(is);
        if (MAGIC_NUMBER.equals(dis.readUTF())) {
            int version = dis.readInt();
            if (version != 1) {
                throw new IllegalArgumentException("Unexpected NDArray encode version " + version);
            }
            dis.readUTF();
        }
        DataType dataType = DataType.valueOf(dis.readUTF());
        Shape shape = Shape.decode(dis);
        ByteBuffer data = manager.allocateDirect(length);
        if (length > 0) {
            byte[] buf = new byte[81920];
            for (length = dis.readInt(); length > 81920; length -= 81920) {
                dis.readFully(buf);
                data.put(buf);
            }
            dis.readFully(buf, 0, length);
            data.put(buf, 0, length);
            data.rewind();
        }
        return manager.create(dataType.asDataType(data), shape);
    }
}

