/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicmodelzoo.cv.object_detection.ssd;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.basicmodelzoo.BasicModelZoo;
import ai.djl.basicmodelzoo.cv.object_detection.ssd.SingleShotDetection;
import ai.djl.modality.cv.zoo.ObjectDetectionModelLoader;
import ai.djl.nn.Block;
import ai.djl.nn.SequentialBlock;
import ai.djl.repository.Artifact;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.ModelZoo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SsdModelLoader
extends ObjectDetectionModelLoader {
    private static final String GROUP_ID = "ai.djl.zoo";
    private static final String ARTIFACT_ID = "ssd";
    private static final String VERSION = "0.0.1";

    public SsdModelLoader(Repository repository) {
        super(repository, GROUP_ID, ARTIFACT_ID, VERSION, (ModelZoo)new BasicModelZoo());
    }

    protected Model createModel(String name, Device device, Artifact artifact, Map<String, Object> arguments, String engine) {
        Model model = Model.newInstance((String)name, (Device)device, (String)engine);
        model.setBlock(this.customSSDBlock(arguments));
        return model;
    }

    private Block customSSDBlock(Map<String, Object> arguments) {
        int numClasses = ((Double)arguments.get("outSize")).intValue();
        int numFeatures = ((Double)arguments.get("numFeatures")).intValue();
        boolean globalPool = (Boolean)arguments.get("globalPool");
        int[] numFilters = ((List)arguments.get("numFilters")).stream().mapToInt(Double::intValue).toArray();
        List ratio = ((List)arguments.get("ratios")).stream().map(Double::floatValue).collect(Collectors.toList());
        List<List<Float>> sizes = ((List)arguments.get("sizes")).stream().map(size -> size.stream().map(Double::floatValue).collect(Collectors.toList())).collect(Collectors.toList());
        ArrayList<List<Float>> ratios = new ArrayList<List<Float>>();
        for (int i = 0; i < 5; ++i) {
            ratios.add(ratio);
        }
        SequentialBlock baseBlock = new SequentialBlock();
        for (int numFilter : numFilters) {
            baseBlock.add((Block)SingleShotDetection.getDownSamplingBlock(numFilter));
        }
        return SingleShotDetection.builder().setNumClasses(numClasses).setNumFeatures(numFeatures).optGlobalPool(globalPool).setRatios(ratios).setSizes(sizes).setBaseNetwork((Block)baseBlock).build();
    }
}

