/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassLoaderUtils.class);

    private ClassLoaderUtils() {
    }

    public static <T> T findImplementation(Path path, String className) {
        try {
            Path classesDir = path.resolve("classes");
            List jarFiles = Files.list(path).filter(p -> p.toString().endsWith(".jar")).collect(Collectors.toList());
            URL[] urls = new URL[jarFiles.size() + 1];
            urls[0] = classesDir.toUri().toURL();
            int index = 1;
            for (Path p2 : jarFiles) {
                urls[index++] = p2.toUri().toURL();
            }
            ClassLoader cl = AccessController.doPrivileged(() -> new URLClassLoader(urls, Thread.currentThread().getContextClassLoader()));
            if (className != null && !className.isEmpty()) {
                return ClassLoaderUtils.initClass(cl, className);
            }
            T implemented = ClassLoaderUtils.scanDirectory(cl, classesDir);
            if (implemented != null) {
                return implemented;
            }
            for (Path p3 : jarFiles) {
                implemented = ClassLoaderUtils.scanJarFile(cl, p3);
                if (implemented == null) continue;
                return implemented;
            }
        }
        catch (IOException e) {
            logger.debug("Failed to find Translator", (Throwable)e);
        }
        return null;
    }

    private static <T> T scanDirectory(ClassLoader cl, Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            logger.debug("Directory not exists: {}", (Object)dir);
            return null;
        }
        Collection files = Files.walk(dir, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".class")).collect(Collectors.toList());
        for (Path file : files) {
            Path p2 = dir.relativize(file);
            String className = p2.toString();
            className = className.substring(0, className.lastIndexOf(46));
            T implemented = ClassLoaderUtils.initClass(cl, className = className.replace(File.separatorChar, '.'));
            if (implemented == null) continue;
            return implemented;
        }
        return null;
    }

    private static <T> T scanJarFile(ClassLoader cl, Path path) throws IOException {
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String fileName = entry.getName();
                if (!fileName.endsWith(".class")) continue;
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
                T implemented = ClassLoaderUtils.initClass(cl, fileName = fileName.replace('/', '.'));
                if (implemented == null) continue;
                T t = implemented;
                return t;
            }
        }
        return null;
    }

    private static <T> T initClass(ClassLoader cl, String className) {
        try {
            Class<?> clazz = Class.forName(className, true, cl);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            logger.trace("Not able to load Object", e);
            return null;
        }
    }
}

