/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.Condition;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class DefaultDebugger
extends ServiceSupport
implements Debugger,
CamelContextAware {
    private final EventNotifier debugEventNotifier = new DebugEventNotifier();
    private final List<BreakpointConditions> breakpoints = new CopyOnWriteArrayList<BreakpointConditions>();
    private final int maxConcurrentSingleSteps = 1;
    private final Map<String, Breakpoint> singleSteps = new HashMap<String, Breakpoint>(1);
    private CamelContext camelContext;

    public DefaultDebugger() {
    }

    public DefaultDebugger(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        this.breakpoints.add(new BreakpointConditions(breakpoint));
    }

    public void addBreakpoint(Breakpoint breakpoint, Condition ... conditions) {
        this.breakpoints.add(new BreakpointConditions(breakpoint, Arrays.asList(conditions)));
    }

    public void addSingleStepBreakpoint(Breakpoint breakpoint) {
        this.addSingleStepBreakpoint(breakpoint, new Condition[0]);
    }

    public void addSingleStepBreakpoint(final Breakpoint breakpoint, Condition ... conditions) {
        Breakpoint singlestep = new Breakpoint(){

            public Breakpoint.State getState() {
                return breakpoint.getState();
            }

            public void suspend() {
                breakpoint.suspend();
            }

            public void activate() {
                breakpoint.activate();
            }

            public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
                breakpoint.beforeProcess(exchange, processor, definition);
            }

            public void afterProcess(Exchange exchange, Processor processor, NamedNode definition, long timeTaken) {
                breakpoint.afterProcess(exchange, processor, definition, timeTaken);
            }

            public void onEvent(Exchange exchange, CamelEvent.ExchangeEvent event, NamedNode definition) {
                if (event instanceof CamelEvent.ExchangeCreatedEvent) {
                    DefaultDebugger.this.startSingleStepExchange(exchange.getExchangeId(), this);
                } else if (event instanceof CamelEvent.ExchangeCompletedEvent) {
                    DefaultDebugger.this.stopSingleStepExchange(exchange.getExchangeId());
                }
                breakpoint.onEvent(exchange, event, definition);
            }

            public String toString() {
                return breakpoint.toString();
            }
        };
        this.addBreakpoint(singlestep, conditions);
    }

    public void removeBreakpoint(Breakpoint breakpoint) {
        for (BreakpointConditions condition : this.breakpoints) {
            if (!condition.getBreakpoint().equals(breakpoint)) continue;
            this.breakpoints.remove(condition);
        }
    }

    public void suspendAllBreakpoints() {
        for (BreakpointConditions breakpoint : this.breakpoints) {
            breakpoint.getBreakpoint().suspend();
        }
    }

    public void activateAllBreakpoints() {
        for (BreakpointConditions breakpoint : this.breakpoints) {
            breakpoint.getBreakpoint().activate();
        }
    }

    public List<Breakpoint> getBreakpoints() {
        ArrayList<Breakpoint> answer = new ArrayList<Breakpoint>(this.breakpoints.size());
        for (BreakpointConditions e : this.breakpoints) {
            answer.add(e.getBreakpoint());
        }
        return Collections.unmodifiableList(answer);
    }

    public boolean startSingleStepExchange(String exchangeId, Breakpoint breakpoint) {
        if (this.singleSteps.size() >= 1) {
            return false;
        }
        this.singleSteps.put(exchangeId, breakpoint);
        return true;
    }

    public void stopSingleStepExchange(String exchangeId) {
        this.singleSteps.remove(exchangeId);
    }

    public boolean beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
        Breakpoint singleStep = this.singleSteps.get(exchange.getExchangeId());
        if (singleStep != null) {
            this.onBeforeProcess(exchange, processor, definition, singleStep);
            return true;
        }
        boolean match = false;
        for (BreakpointConditions breakpoint : this.breakpoints) {
            if (!Breakpoint.State.Active.equals((Object)breakpoint.getBreakpoint().getState()) || !this.matchConditions(exchange, processor, definition, breakpoint)) continue;
            match = true;
            this.onBeforeProcess(exchange, processor, definition, breakpoint.getBreakpoint());
        }
        return match;
    }

    public boolean afterProcess(Exchange exchange, Processor processor, NamedNode definition, long timeTaken) {
        Breakpoint singleStep = this.singleSteps.get(exchange.getExchangeId());
        if (singleStep != null) {
            this.onAfterProcess(exchange, processor, definition, timeTaken, singleStep);
            return true;
        }
        boolean match = false;
        for (BreakpointConditions breakpoint : this.breakpoints) {
            if (!Breakpoint.State.Active.equals((Object)breakpoint.getBreakpoint().getState()) || !this.matchConditions(exchange, processor, definition, breakpoint)) continue;
            match = true;
            this.onAfterProcess(exchange, processor, definition, timeTaken, breakpoint.getBreakpoint());
        }
        return match;
    }

    public boolean onEvent(Exchange exchange, CamelEvent.ExchangeEvent event) {
        Breakpoint singleStep = this.singleSteps.get(exchange.getExchangeId());
        if (singleStep != null) {
            this.onEvent(exchange, event, singleStep);
            return true;
        }
        boolean match = false;
        for (BreakpointConditions breakpoint : this.breakpoints) {
            if (!Breakpoint.State.Active.equals((Object)breakpoint.getBreakpoint().getState()) || !this.matchConditions(exchange, event, breakpoint)) continue;
            match = true;
            this.onEvent(exchange, event, breakpoint.getBreakpoint());
        }
        return match;
    }

    protected void onBeforeProcess(Exchange exchange, Processor processor, NamedNode definition, Breakpoint breakpoint) {
        try {
            breakpoint.beforeProcess(exchange, processor, definition);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void onAfterProcess(Exchange exchange, Processor processor, NamedNode definition, long timeTaken, Breakpoint breakpoint) {
        try {
            breakpoint.afterProcess(exchange, processor, definition, timeTaken);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void onEvent(Exchange exchange, CamelEvent.ExchangeEvent event, Breakpoint breakpoint) {
        LinkedList list = (LinkedList)exchange.getProperty("CamelMessageHistory", LinkedList.class);
        MessageHistory last = list != null ? (MessageHistory)list.getLast() : null;
        NamedNode definition = last != null ? last.getNode() : null;
        try {
            breakpoint.onEvent(exchange, event, definition);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean matchConditions(Exchange exchange, Processor processor, NamedNode definition, BreakpointConditions breakpoint) {
        for (Condition condition : breakpoint.getConditions()) {
            if (condition.matchProcess(exchange, processor, definition)) continue;
            return false;
        }
        return true;
    }

    private boolean matchConditions(Exchange exchange, CamelEvent.ExchangeEvent event, BreakpointConditions breakpoint) {
        for (Condition condition : breakpoint.getConditions()) {
            if (condition.matchEvent(exchange, event)) continue;
            return false;
        }
        return true;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        if (!this.camelContext.isMessageHistory().booleanValue()) {
            this.camelContext.setMessageHistory(Boolean.valueOf(true));
        }
        ServiceHelper.startService((Object)this.debugEventNotifier);
        this.camelContext.getManagementStrategy().addEventNotifier(this.debugEventNotifier);
    }

    protected void doStop() throws Exception {
        this.breakpoints.clear();
        this.singleSteps.clear();
        ServiceHelper.stopService((Object)this.debugEventNotifier);
    }

    public String toString() {
        return "DefaultDebugger";
    }

    private final class DebugEventNotifier
    extends EventNotifierSupport {
        private DebugEventNotifier() {
            this.setIgnoreCamelContextEvents(true);
            this.setIgnoreServiceEvents(true);
        }

        public void notify(CamelEvent event) throws Exception {
            CamelEvent.ExchangeEvent aee = (CamelEvent.ExchangeEvent)event;
            Exchange exchange = aee.getExchange();
            DefaultDebugger.this.onEvent(exchange, aee);
            if (event instanceof CamelEvent.ExchangeCompletedEvent) {
                DefaultDebugger.this.singleSteps.remove(exchange.getExchangeId());
            }
        }

        public boolean isEnabled(CamelEvent event) {
            return event instanceof CamelEvent.ExchangeEvent;
        }
    }

    private static final class BreakpointConditions {
        private final Breakpoint breakpoint;
        private final List<Condition> conditions;

        private BreakpointConditions(Breakpoint breakpoint) {
            this(breakpoint, new ArrayList<Condition>());
        }

        private BreakpointConditions(Breakpoint breakpoint, List<Condition> conditions) {
            this.breakpoint = breakpoint;
            this.conditions = conditions;
        }

        public Breakpoint getBreakpoint() {
            return this.breakpoint;
        }

        public List<Condition> getConditions() {
            return this.conditions;
        }
    }
}

