/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.impl.engine.DefaultProducerCache;
import org.apache.camel.impl.engine.EmptyProducerCache;
import org.apache.camel.processor.SendDynamicAwareResolver;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendDynamicProcessor
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(SendDynamicProcessor.class);
    protected SendDynamicAware dynamicAware;
    protected CamelContext camelContext;
    protected final String uri;
    protected final Expression expression;
    protected ExchangePattern pattern;
    protected ProducerCache producerCache;
    protected String id;
    protected String routeId;
    protected boolean ignoreInvalidEndpoint;
    protected int cacheSize;
    protected boolean allowOptimisedComponents = true;

    public SendDynamicProcessor(String uri, Expression expression) {
        this.uri = uri;
        this.expression = expression;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        ExchangePattern destinationExchangePattern;
        Endpoint endpoint;
        if (!this.isStarted()) {
            exchange.setException((Throwable)new IllegalStateException("SendProcessor has not been started: " + (Object)((Object)this)));
            callback.done(true);
            return true;
        }
        final ExchangePattern existingPattern = exchange.getPattern();
        Object recipient = null;
        Processor preAwareProcessor = null;
        Processor postAwareProcessor = null;
        String staticUri = null;
        try {
            recipient = this.expression.evaluate(exchange, Object.class);
            if (this.dynamicAware != null) {
                SendDynamicAware.DynamicAwareEntry entry;
                String originalUri = this.uri;
                String uri = SendDynamicProcessor.resolveUri(exchange, recipient);
                String scheme = SendDynamicProcessor.resolveScheme(exchange, uri);
                if (this.dynamicAware.getScheme().equals(scheme) && (entry = this.dynamicAware.prepare(exchange, uri, originalUri)) != null) {
                    staticUri = this.dynamicAware.resolveStaticUri(exchange, entry);
                    preAwareProcessor = this.dynamicAware.createPreProcessor(exchange, entry);
                    postAwareProcessor = this.dynamicAware.createPostProcessor(exchange, entry);
                    if (staticUri != null && LOG.isDebugEnabled()) {
                        LOG.debug("Optimising toD via SendDynamicAware component: {} to use static uri: {}", (Object)scheme, (Object)URISupport.sanitizeUri((String)staticUri));
                    }
                }
            }
            if ((endpoint = staticUri != null ? SendDynamicProcessor.resolveEndpoint(exchange, staticUri) : SendDynamicProcessor.resolveEndpoint(exchange, recipient)) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Send dynamic evaluated as null so cannot send to any endpoint");
                }
                callback.done(true);
                return true;
            }
            destinationExchangePattern = EndpointHelper.resolveExchangePatternFromUrl((String)endpoint.getEndpointUri());
        }
        catch (Throwable e2) {
            if (this.isIgnoreInvalidEndpoint()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Endpoint uri is invalid: " + recipient + ". This exception will be ignored.", e2);
                }
            } else {
                exchange.setException(e2);
            }
            callback.done(true);
            return true;
        }
        Processor preProcessor = preAwareProcessor;
        final Processor postProcessor = postAwareProcessor;
        ExchangePattern pattern = destinationExchangePattern != null ? destinationExchangePattern : this.pattern;
        return this.producerCache.doInAsyncProducer(endpoint, exchange, callback, (p, e, c) -> {
            final Exchange target = this.configureExchange(e, pattern, endpoint);
            try {
                if (preProcessor != null) {
                    preProcessor.process(target);
                }
            }
            catch (Throwable t) {
                e.setException(t);
                target.setPattern(existingPattern);
                c.done(true);
            }
            LOG.debug(">>>> {} {}", (Object)endpoint, (Object)e);
            return p.process(target, new AsyncCallback(){

                public void done(boolean doneSync) {
                    target.setPattern(existingPattern);
                    try {
                        if (postProcessor != null) {
                            postProcessor.process(target);
                        }
                    }
                    catch (Throwable e) {
                        target.setException(e);
                    }
                    c.done(doneSync);
                }
            });
        });
    }

    protected static String resolveUri(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient == null) {
            return null;
        }
        String uri = recipient instanceof String ? ((String)recipient).trim() : (recipient instanceof Endpoint ? ((Endpoint)recipient).getEndpointKey() : (String)exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient));
        try {
            uri = exchange.getContext().resolvePropertyPlaceholders(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        return uri;
    }

    protected static String resolveScheme(Exchange exchange, String uri) {
        return ExchangeHelper.resolveScheme((String)uri);
    }

    protected static Endpoint resolveEndpoint(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        } else {
            if (recipient instanceof Endpoint) {
                return (Endpoint)recipient;
            }
            if (recipient != null) {
                recipient = exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient);
            }
        }
        if (recipient != null) {
            return ExchangeHelper.resolveEndpoint((Exchange)exchange, (Object)recipient);
        }
        return null;
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern, Endpoint endpoint) {
        if (pattern != null) {
            exchange.setPattern(pattern);
        }
        exchange.setProperty("CamelToEndpoint", (Object)endpoint.getEndpointUri());
        return exchange;
    }

    protected void doStart() throws Exception {
        block8: {
            if (this.producerCache == null) {
                if (this.cacheSize < 0) {
                    this.producerCache = new EmptyProducerCache((Object)this, this.camelContext);
                    LOG.debug("DynamicSendTo {} is not using ProducerCache", (Object)this);
                } else {
                    this.producerCache = new DefaultProducerCache((Object)this, this.camelContext, this.cacheSize);
                    LOG.debug("DynamicSendTo {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
                }
            }
            if (this.isAllowOptimisedComponents() && this.uri != null) {
                try {
                    String u = this.camelContext.resolvePropertyPlaceholders(this.uri);
                    String scheme = ExchangeHelper.resolveScheme((String)u);
                    if (scheme != null) {
                        SendDynamicAwareResolver resolver = new SendDynamicAwareResolver();
                        this.dynamicAware = resolver.resolve(this.camelContext, scheme);
                        if (this.dynamicAware != null && LOG.isDebugEnabled()) {
                            LOG.debug("Detected SendDynamicAware component: {} optimising toD: {}", (Object)scheme, (Object)URISupport.sanitizeUri((String)this.uri));
                        }
                    }
                }
                catch (Throwable e) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug("Error creating optimised SendDynamicAwareResolver for uri: " + URISupport.sanitizeUri((String)this.uri) + " due to " + e.getMessage() + ". This exception is ignored", e);
                }
            }
        }
        ServiceHelper.startService((Object)this.producerCache);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.producerCache);
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.producerCache.getEndpointUtilizationStatistics();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public SendDynamicAware getDynamicAware() {
        return this.dynamicAware;
    }

    public String getUri() {
        return this.uri;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isAllowOptimisedComponents() {
        return this.allowOptimisedComponents;
    }

    public void setAllowOptimisedComponents(boolean allowOptimisedComponents) {
        this.allowOptimisedComponents = allowOptimisedComponents;
    }
}

