/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.saga;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.saga.InMemorySagaCoordinator;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class InMemorySagaService
extends ServiceSupport
implements CamelSagaService {
    public static final int DEFAULT_MAX_RETRY_ATTEMPTS = 5;
    public static final long DEFAULT_RETRY_DELAY_IN_MILLISECONDS = 5000L;
    private CamelContext camelContext;
    private Map<String, CamelSagaCoordinator> coordinators = new ConcurrentHashMap<String, CamelSagaCoordinator>();
    private ScheduledExecutorService executorService;
    private int maxRetryAttempts = 5;
    private long retryDelayInMilliseconds = 5000L;

    public CompletableFuture<CamelSagaCoordinator> newSaga() {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        String uuid = this.camelContext.getUuidGenerator().generateUuid();
        InMemorySagaCoordinator coordinator = new InMemorySagaCoordinator(this.camelContext, this, uuid);
        this.coordinators.put(uuid, coordinator);
        return CompletableFuture.completedFuture(coordinator);
    }

    public CompletableFuture<CamelSagaCoordinator> getSaga(String id) {
        return CompletableFuture.completedFuture(this.coordinators.get(id));
    }

    public void registerStep(CamelSagaStep step) {
    }

    protected void doStart() throws Exception {
        if (this.executorService == null) {
            this.executorService = this.camelContext.getExecutorServiceManager().newDefaultScheduledThreadPool((Object)this, "saga");
        }
    }

    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownGraceful((ExecutorService)this.executorService);
            this.executorService = null;
        }
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public void setMaxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
    }

    public long getRetryDelayInMilliseconds() {
        return this.retryDelayInMilliseconds;
    }

    public void setRetryDelayInMilliseconds(long retryDelayInMilliseconds) {
        this.retryDelayInMilliseconds = retryDelayInMilliseconds;
    }
}

