/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.spi.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeCamelCatalogResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/";
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeCamelCatalogResolver.class);
    private FactoryFinder factoryFinder;

    public RuntimeCamelCatalog resolve(CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findFactory("runtime-camelcatalog", context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found RuntimeCamelCatalog: {} via: {}{}", new Object[]{type.getName(), this.factoryFinder.getResourcePath(), "runtime-camelcatalog"});
            }
            if (RuntimeCamelCatalog.class.isAssignableFrom(type)) {
                RuntimeCamelCatalog answer = (RuntimeCamelCatalog)context.getInjector().newInstance(type, false);
                answer.setCamelContext(context);
                LOG.info("Detected and using RuntimeCamelCatalog: {}", (Object)answer);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a RuntimeCamelCatalog implementation. Found: " + type.getName());
        }
        throw new IllegalArgumentException("Cannot find RuntimeCamelCatalog on classpath. Add camel-core-catalog to classpath.");
    }

    private Class<?> findFactory(String name, CamelContext context) throws IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name).orElse(null);
    }
}

