/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.WrappedFile;
import org.apache.camel.support.TypeConverterSupport;

public class ToStringTypeConverter
extends TypeConverterSupport {
    static Set<Class<?>> missTypes = new HashSet();

    public static void registerMissType(Class clazz) {
        missTypes.add(clazz);
    }

    public <T> T convertTo(Class<T> toType, Exchange exchange, Object value) {
        if (missTypes.stream().anyMatch(cl -> cl.isAssignableFrom(value.getClass()))) {
            return (T)MISS_VALUE;
        }
        if (toType.equals(String.class)) {
            return (T)value.toString();
        }
        return null;
    }

    static {
        ToStringTypeConverter.registerMissType(Message.class);
        ToStringTypeConverter.registerMissType(Future.class);
        ToStringTypeConverter.registerMissType(WrappedFile.class);
    }
}

