/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.processor.WrapProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactedReifier
extends ProcessorReifier<TransactedDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(TransactedReifier.class);

    public TransactedReifier(RouteContext routeContext, ProcessorDefinition<?> definition) {
        super(routeContext, (TransactedDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Policy policy = this.resolvePolicy(this.routeContext);
        ObjectHelper.notNull((Object)policy, (String)"policy", (Object)this);
        policy.beforeWrap(this.routeContext, (NamedNode)this.definition);
        Processor childProcessor = this.createChildProcessor(true);
        Processor target = policy.wrap(this.routeContext, childProcessor);
        if (!(target instanceof Service)) {
            target = new WrapProcessor(target, childProcessor);
        }
        return target;
    }

    protected Policy resolvePolicy(RouteContext routeContext) {
        return TransactedReifier.resolvePolicy(routeContext, (TransactedDefinition)this.definition);
    }

    public static Policy resolvePolicy(RouteContext routeContext, TransactedDefinition definition) {
        if (definition.getPolicy() != null) {
            return definition.getPolicy();
        }
        return TransactedReifier.resolvePolicy(routeContext, definition.getRef(), definition.getType());
    }

    public static Policy resolvePolicy(RouteContext routeContext, String ref, Class<? extends Policy> type) {
        Class tmClazz;
        Object found;
        Map types;
        if (ObjectHelper.isNotEmpty((Object)ref)) {
            return (Policy)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)ref, Policy.class);
        }
        Policy answer = null;
        if (type != null && (types = routeContext.lookupByType(type)).size() == 1 && type.isInstance(found = types.values().iterator().next())) {
            return type.cast(found);
        }
        if (type == TransactedPolicy.class) {
            answer = (Policy)routeContext.lookup("PROPAGATION_REQUIRED", TransactedPolicy.class);
        }
        if (answer == null && type == TransactedPolicy.class && (tmClazz = routeContext.getCamelContext().getClassResolver().resolveClass("org.springframework.transaction.PlatformTransactionManager")) != null) {
            Map maps = routeContext.lookupByType(tmClazz);
            if (maps.size() == 1) {
                Object transactionManager = maps.values().iterator().next();
                LOG.debug("One instance of PlatformTransactionManager found in registry: {}", transactionManager);
                Class txClazz = routeContext.getCamelContext().getClassResolver().resolveClass("org.apache.camel.spring.spi.SpringTransactionPolicy");
                if (txClazz != null) {
                    Method method;
                    LOG.debug("Creating a new temporary SpringTransactionPolicy using the PlatformTransactionManager: {}", transactionManager);
                    TransactedPolicy txPolicy = (TransactedPolicy)org.apache.camel.support.ObjectHelper.newInstance((Class)txClazz, TransactedPolicy.class);
                    try {
                        method = txClazz.getMethod("setTransactionManager", tmClazz);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeCamelException("Cannot get method setTransactionManager(PlatformTransactionManager) on class: " + txClazz);
                    }
                    org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)txPolicy, (Object[])new Object[]{transactionManager});
                    return txPolicy;
                }
                throw new RuntimeCamelException("Cannot create a transacted policy as camel-spring.jar is not on the classpath!");
            }
            if (maps.isEmpty()) {
                throw new NoSuchBeanException(null, "PlatformTransactionManager");
            }
            throw new IllegalArgumentException("Found " + maps.size() + " PlatformTransactionManager in registry. Cannot determine which one to use. Please configure a TransactionTemplate on the transacted policy.");
        }
        return answer;
    }
}

