/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.FatalFallbackErrorHandler;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.RouteContext;

public class OnExceptionReifier
extends ProcessorReifier<OnExceptionDefinition> {
    public OnExceptionReifier(RouteContext routeContext, ProcessorDefinition<?> definition) {
        super(routeContext, (OnExceptionDefinition)definition);
    }

    @Override
    public void addRoutes() throws Exception {
        Processor child;
        if (((OnExceptionDefinition)this.definition).getRouteScoped() == null) {
            ((OnExceptionDefinition)this.definition).setRouteScoped(((OnExceptionDefinition)this.definition).getParent() != null);
        }
        ((OnExceptionDefinition)this.definition).validateConfiguration();
        if (this.parseBoolean(((OnExceptionDefinition)this.definition).getUseOriginalMessage(), false)) {
            this.routeContext.setAllowUseOriginalMessage(Boolean.valueOf(true));
        }
        if ((child = this.createOutputsProcessor()) != null) {
            FatalFallbackErrorHandler errorHandler = new FatalFallbackErrorHandler(child);
            String id = this.getId(this.definition, this.routeContext);
            this.routeContext.setOnException(id, (Processor)errorHandler);
        }
        ErrorHandlerBuilder builder = (ErrorHandlerBuilder)this.routeContext.getErrorHandlerFactory();
        this.routeContext.addErrorHandler((ErrorHandlerFactory)builder, (NamedNode)this.definition);
    }

    public CatchProcessor createProcessor() throws Exception {
        List<Class<? extends Throwable>> classes = null;
        if (((OnExceptionDefinition)this.definition).getExceptions() != null && !((OnExceptionDefinition)this.definition).getExceptions().isEmpty()) {
            classes = this.createExceptionClasses(this.camelContext.getClassResolver());
        }
        if (this.parseBoolean(((OnExceptionDefinition)this.definition).getUseOriginalMessage(), false)) {
            this.routeContext.setAllowUseOriginalMessage(Boolean.valueOf(true));
        }
        ((OnExceptionDefinition)this.definition).validateConfiguration();
        Processor childProcessor = this.createChildProcessor(false);
        Predicate when = null;
        if (((OnExceptionDefinition)this.definition).getOnWhen() != null) {
            when = this.createPredicate(((OnExceptionDefinition)this.definition).getOnWhen().getExpression());
        }
        Predicate handle = null;
        if (((OnExceptionDefinition)this.definition).getHandled() != null) {
            handle = this.createPredicate(((OnExceptionDefinition)this.definition).getHandled());
        }
        return new CatchProcessor(classes, childProcessor, when, handle);
    }

    protected List<Class<? extends Throwable>> createExceptionClasses(ClassResolver resolver) throws ClassNotFoundException {
        List<String> list = ((OnExceptionDefinition)this.definition).getExceptions();
        ArrayList<Class<? extends Throwable>> answer = new ArrayList<Class<? extends Throwable>>(list.size());
        for (String name : list) {
            Class type = resolver.resolveMandatoryClass(name, Throwable.class);
            answer.add(type);
        }
        return answer;
    }
}

