/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.processor.DelegateAsyncProcessor;

public class NoErrorHandlerBuilder
extends ErrorHandlerBuilderSupport {
    public Processor createErrorHandler(RouteContext routeContext, Processor processor) {
        return new DelegateAsyncProcessor(processor){

            public boolean process(final Exchange exchange, final AsyncCallback callback) {
                return super.process(exchange, new AsyncCallback(){

                    public void done(boolean doneSync) {
                        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setRedeliveryExhausted(false);
                        callback.done(doneSync);
                    }
                });
            }

            public String toString() {
                if (this.processor == null) {
                    return "";
                }
                return "NoErrorHandler[" + this.processor + "]";
            }
        };
    }

    @Override
    public boolean supportTransacted() {
        return false;
    }

    @Override
    public ErrorHandlerBuilder cloneBuilder() {
        NoErrorHandlerBuilder answer = new NoErrorHandlerBuilder();
        this.cloneBuilder(answer);
        return answer;
    }
}

