/*
 * Decompiled with CFR 0.152.
 */
package com.myjeeva.digitalocean.common;

import org.apache.commons.lang3.StringUtils;

public enum LoadBalancingAlgorithm {
    ROUND_ROBIN("round_robin"),
    LEAST_CONNECTIONS("least_connections");

    private String value;

    private LoadBalancingAlgorithm(String value) {
        this.value = value;
    }

    public static LoadBalancingAlgorithm fromValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        for (LoadBalancingAlgorithm ds : LoadBalancingAlgorithm.values()) {
            if (!value.equalsIgnoreCase(ds.value)) continue;
            return ds;
        }
        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }

    public String toString() {
        return this.value;
    }
}

