/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.sqlserver.ChangeTable;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.BoundedConcurrentHashMap;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnection
extends JdbcConnection {
    public static final String SERVER_TIMEZONE_PROP_NAME = "server.timezone";
    private static final String GET_DATABASE_NAME = "SELECT db_name()";
    private static Logger LOGGER = LoggerFactory.getLogger(SqlServerConnection.class);
    private static final String STATEMENTS_PLACEHOLDER = "#";
    private static final String GET_MAX_LSN = "SELECT sys.fn_cdc_get_max_lsn()";
    private static final String LOCK_TABLE = "SELECT * FROM [#] WITH (TABLOCKX)";
    private static final String SQL_SERVER_VERSION = "SELECT @@VERSION AS 'SQL Server Version'";
    private final String lsnToTimestamp;
    private static final String INCREMENT_LSN = "SELECT sys.fn_cdc_increment_lsn(?)";
    private static final String GET_ALL_CHANGES_FOR_TABLE = "SELECT * FROM cdc.[fn_cdc_get_all_changes_#](ISNULL(?,sys.fn_cdc_get_min_lsn('#')), ?, N'all update old')";
    private static final String GET_LIST_OF_CDC_ENABLED_TABLES = "EXEC sys.sp_cdc_help_change_data_capture";
    private static final String GET_LIST_OF_NEW_CDC_ENABLED_TABLES = "SELECT * FROM cdc.change_tables WHERE start_lsn BETWEEN ? AND ?";
    private static final String GET_LIST_OF_KEY_COLUMNS = "SELECT * FROM cdc.index_columns WHERE object_id=?";
    private static final int CHANGE_TABLE_DATA_COLUMN_OFFSET = 5;
    private static final String URL_PATTERN = "jdbc:sqlserver://${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "};databaseName=${" + JdbcConfiguration.DATABASE + "}";
    private static final JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)URL_PATTERN, (String)SQLServerDriver.class.getName(), (ClassLoader)SqlServerConnection.class.getClassLoader(), (Field[])new Field[0]);
    private final String realDatabaseName;
    private final ZoneId transactionTimezone;
    private final BoundedConcurrentHashMap<Lsn, Instant> lsnToInstantCache = new BoundedConcurrentHashMap(100);

    public SqlServerConnection(Configuration config) {
        super(config, FACTORY);
        this.realDatabaseName = this.retrieveRealDatabaseName();
        boolean supportsAtTimeZone = this.supportsAtTimeZone();
        this.transactionTimezone = this.retrieveTransactionTimezone(supportsAtTimeZone);
        this.lsnToTimestamp = SqlServerConnection.getLsnToTimestamp(supportsAtTimeZone);
    }

    private static String getLsnToTimestamp(boolean supportsAtTimeZone) {
        String lsnToTimestamp = "SELECT sys.fn_cdc_map_lsn_to_time(?)";
        if (supportsAtTimeZone) {
            lsnToTimestamp = lsnToTimestamp + " AT TIME ZONE 'UTC'";
        }
        return lsnToTimestamp;
    }

    public Lsn getMaxLsn() throws SQLException {
        return (Lsn)this.queryAndMap(GET_MAX_LSN, this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Current maximum lsn is {}", (Object)ret);
            return ret;
        }, "Maximum LSN query must return exactly one value"));
    }

    public void getChangesForTable(TableId tableId, Lsn fromLsn, Lsn toLsn, JdbcConnection.ResultSetConsumer consumer) throws SQLException {
        String query = GET_ALL_CHANGES_FOR_TABLE.replace(STATEMENTS_PLACEHOLDER, this.cdcNameForTable(tableId));
        this.prepareQuery(query, statement -> {
            statement.setBytes(1, fromLsn.getBinary());
            statement.setBytes(2, toLsn.getBinary());
        }, consumer);
    }

    public void getChangesForTables(ChangeTable[] changeTables, Lsn intervalFromLsn, Lsn intervalToLsn, JdbcConnection.BlockingMultiResultSetConsumer consumer) throws SQLException, InterruptedException {
        String[] queries = new String[changeTables.length];
        JdbcConnection.StatementPreparer[] preparers = new JdbcConnection.StatementPreparer[changeTables.length];
        int idx = 0;
        for (ChangeTable changeTable : changeTables) {
            String query;
            queries[idx] = query = GET_ALL_CHANGES_FOR_TABLE.replace(STATEMENTS_PLACEHOLDER, changeTable.getCaptureInstance());
            Lsn fromLsn = changeTable.getStartLsn().compareTo(intervalFromLsn) > 0 ? changeTable.getStartLsn() : intervalFromLsn;
            LOGGER.trace("Getting changes for table {} in range[{}, {}]", new Object[]{changeTable, fromLsn, intervalToLsn});
            preparers[idx] = statement -> {
                statement.setBytes(1, fromLsn.getBinary());
                statement.setBytes(2, intervalToLsn.getBinary());
            };
            ++idx;
        }
        this.prepareQuery(queries, preparers, consumer);
    }

    public Lsn incrementLsn(Lsn lsn) throws SQLException {
        String query = INCREMENT_LSN;
        return (Lsn)this.prepareQueryAndMap(INCREMENT_LSN, statement -> statement.setBytes(1, lsn.getBinary()), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Increasing lsn from {} to {}", (Object)lsn, (Object)ret);
            return ret;
        }, "Increment LSN query must return exactly one value"));
    }

    public Instant timestampOfLsn(Lsn lsn) throws SQLException {
        if (lsn.getBinary() == null) {
            return null;
        }
        Instant cachedInstant = (Instant)this.lsnToInstantCache.get((Object)lsn);
        if (cachedInstant != null) {
            return cachedInstant;
        }
        return (Instant)this.prepareQueryAndMap(this.lsnToTimestamp, statement -> statement.setBytes(1, lsn.getBinary()), this.singleResultMapper(rs -> {
            Timestamp ts = rs.getTimestamp(1);
            Instant ret = ts == null ? null : this.normalize(ts);
            LOGGER.trace("Timestamp of lsn {} is {}", (Object)lsn, (Object)ret);
            if (ret != null) {
                this.lsnToInstantCache.put((Object)lsn, (Object)ret);
            }
            return ret;
        }, "LSN to timestamp query must return exactly one value"));
    }

    private Instant normalize(Timestamp timestamp) {
        Instant instant = timestamp.toInstant();
        if (!this.transactionTimezone.getId().equals("UTC")) {
            instant = instant.atZone(this.transactionTimezone).toLocalDateTime().toInstant(ZoneOffset.UTC);
        }
        return instant;
    }

    public void lockTable(TableId tableId) throws SQLException {
        String lockTableStmt = LOCK_TABLE.replace(STATEMENTS_PLACEHOLDER, tableId.table());
        this.execute(new String[]{lockTableStmt});
    }

    private String cdcNameForTable(TableId tableId) {
        return tableId.schema() + '_' + tableId.table();
    }

    public <T> JdbcConnection.ResultSetMapper<T> singleResultMapper(ResultSetExtractor<T> extractor, String error) throws SQLException {
        return rs -> {
            if (rs.next()) {
                Object ret = extractor.apply(rs);
                if (!rs.next()) {
                    return ret;
                }
            }
            throw new IllegalStateException(error);
        };
    }

    public Set<ChangeTable> listOfChangeTables() throws SQLException {
        String query = GET_LIST_OF_CDC_ENABLED_TABLES;
        return (Set)this.queryAndMap(GET_LIST_OF_CDC_ENABLED_TABLES, rs -> {
            HashSet<ChangeTable> changeTables = new HashSet<ChangeTable>();
            while (rs.next()) {
                changeTables.add(new ChangeTable(new TableId(this.realDatabaseName, rs.getString(1), rs.getString(2)), rs.getString(3), rs.getInt(4), Lsn.valueOf(rs.getBytes(6)), Lsn.valueOf(rs.getBytes(7))));
            }
            return changeTables;
        });
    }

    public Set<ChangeTable> listOfNewChangeTables(Lsn fromLsn, Lsn toLsn) throws SQLException {
        String query = GET_LIST_OF_NEW_CDC_ENABLED_TABLES;
        return (Set)this.prepareQueryAndMap(GET_LIST_OF_NEW_CDC_ENABLED_TABLES, ps -> {
            ps.setBytes(1, fromLsn.getBinary());
            ps.setBytes(2, toLsn.getBinary());
        }, rs -> {
            HashSet<ChangeTable> changeTables = new HashSet<ChangeTable>();
            while (rs.next()) {
                changeTables.add(new ChangeTable(rs.getString(4), rs.getInt(1), Lsn.valueOf(rs.getBytes(5)), Lsn.valueOf(rs.getBytes(6))));
            }
            return changeTables;
        });
    }

    public Table getTableSchemaFromTable(ChangeTable changeTable) throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        ArrayList columns = new ArrayList();
        try (ResultSet rs = metadata.getColumns(this.realDatabaseName, changeTable.getSourceTableId().schema(), changeTable.getSourceTableId().table(), null);){
            while (rs.next()) {
                this.readTableColumn(rs, changeTable.getSourceTableId(), null).ifPresent(ce -> columns.add(ce.create()));
            }
        }
        List pkColumnNames = this.readPrimaryKeyOrUniqueIndexNames(metadata, changeTable.getSourceTableId());
        Collections.sort(columns);
        return Table.editor().tableId(changeTable.getSourceTableId()).addColumns(columns).setPrimaryKeyNames(pkColumnNames).create();
    }

    public Table getTableSchemaFromChangeTable(ChangeTable changeTable) throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        TableId changeTableId = changeTable.getChangeTableId();
        ArrayList columnEditors = new ArrayList();
        try (ResultSet rs2 = metadata.getColumns(this.realDatabaseName, changeTableId.schema(), changeTableId.table(), null);){
            while (rs2.next()) {
                this.readTableColumn(rs2, changeTableId, null).ifPresent(columnEditors::add);
            }
        }
        List columns = columnEditors.subList(5, columnEditors.size() - 1).stream().map(c -> c.position(c.position() - 5).create()).collect(Collectors.toList());
        ArrayList pkColumnNames = new ArrayList();
        this.prepareQuery(GET_LIST_OF_KEY_COLUMNS, ps -> ps.setInt(1, changeTable.getChangeTableObjectId()), rs -> {
            while (rs.next()) {
                pkColumnNames.add(rs.getString(2));
            }
        });
        Collections.sort(columns);
        return Table.editor().tableId(changeTable.getSourceTableId()).addColumns(columns).setPrimaryKeyNames(pkColumnNames).create();
    }

    public synchronized void rollback() throws SQLException {
        if (this.isConnected()) {
            this.connection().rollback();
        }
    }

    public String getNameOfChangeTable(String captureName) {
        return captureName + "_CT";
    }

    public String getRealDatabaseName() {
        return this.realDatabaseName;
    }

    private ZoneId retrieveTransactionTimezone(boolean supportsAtTimeZone) {
        String serverTimezoneConfig = this.config().getString(SERVER_TIMEZONE_PROP_NAME);
        if (supportsAtTimeZone) {
            if (serverTimezoneConfig != null) {
                LOGGER.warn("The '{}' option should not be specified with SQL Server 2016 and newer", (Object)SERVER_TIMEZONE_PROP_NAME);
            }
        } else if (serverTimezoneConfig == null) {
            LOGGER.warn("The '{}' option should be specified to avoid incorrect timestamp values in case of different timezones between the database server and this connector's JVM.", (Object)SERVER_TIMEZONE_PROP_NAME);
        }
        return serverTimezoneConfig == null ? ZoneId.of("UTC") : ZoneId.of(serverTimezoneConfig, ZoneId.SHORT_IDS);
    }

    private String retrieveRealDatabaseName() {
        try {
            return (String)this.queryAndMap(GET_DATABASE_NAME, this.singleResultMapper(rs -> rs.getString(1), "Could not retrieve database name"));
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't obtain database name", e);
        }
    }

    private boolean supportsAtTimeZone() {
        try {
            return this.getSqlServerVersion() > 2016;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't obtain database server version; assuming 'AT TIME ZONE' is not supported.", (Throwable)e);
            return false;
        }
    }

    private int getSqlServerVersion() {
        try {
            String version = (String)this.queryAndMap(SQL_SERVER_VERSION, this.singleResultMapper(rs -> rs.getString(1), "Could not obtain SQL Server version"));
            return Integer.valueOf(version.substring(21, 25));
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't obtain database server version", e);
        }
    }

    public static class CdcEnabledTable {
        private final String tableId;
        private final String captureName;
        private final Lsn fromLsn;

        private CdcEnabledTable(String tableId, String captureName, Lsn fromLsn) {
            this.tableId = tableId;
            this.captureName = captureName;
            this.fromLsn = fromLsn;
        }

        public String getTableId() {
            return this.tableId;
        }

        public String getCaptureName() {
            return this.captureName;
        }

        public Lsn getFromLsn() {
            return this.fromLsn;
        }
    }

    public static interface ResultSetExtractor<T> {
        public T apply(ResultSet var1) throws SQLException;
    }
}

