/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxws;

import org.apache.camel.component.cxf.jaxws.CxfConfigurer;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;

public final class ChainedCxfConfigurer
implements CxfConfigurer {
    private CxfConfigurer parent;
    private CxfConfigurer child;

    private ChainedCxfConfigurer() {
    }

    public static ChainedCxfConfigurer create(CxfConfigurer parent, CxfConfigurer child) {
        ChainedCxfConfigurer result = new ChainedCxfConfigurer();
        result.parent = parent;
        result.child = child;
        return result;
    }

    public ChainedCxfConfigurer addChild(CxfConfigurer cxfConfigurer) {
        ChainedCxfConfigurer result = new ChainedCxfConfigurer();
        result.parent = this;
        result.child = cxfConfigurer;
        return result;
    }

    @Override
    public void configure(AbstractWSDLBasedEndpointFactory factoryBean) {
        this.parent.configure(factoryBean);
        this.child.configure(factoryBean);
    }

    @Override
    public void configureClient(Client client) {
        this.parent.configureClient(client);
        this.child.configureClient(client);
    }

    @Override
    public void configureServer(Server server) {
        this.parent.configureServer(server);
        this.child.configureServer(server);
    }

    public static class NullCxfConfigurer
    implements CxfConfigurer {
        @Override
        public void configure(AbstractWSDLBasedEndpointFactory factoryBean) {
        }

        @Override
        public void configureClient(Client client) {
        }

        @Override
        public void configureServer(Server server) {
        }
    }
}

