/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.LineNumberAware;
import org.apache.camel.NamedRoute;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;

public final class LoggerHelper {
    private LoggerHelper() {
    }

    public static String getLineNumberLoggerName(Object node) {
        Object name = null;
        if (node instanceof LineNumberAware) {
            if (node instanceof NamedRoute) {
                node = ((NamedRoute)node).getInput();
            }
            String loc = ((LineNumberAware)node).getLocation();
            int line = ((LineNumberAware)node).getLineNumber();
            if (loc != null) {
                name = loc;
                if (loc.contains(":")) {
                    loc = loc.substring(loc.indexOf(58) + 1);
                    name = FileUtil.stripPath((String)loc);
                } else {
                    int pos = ((String)name).lastIndexOf(46);
                    if (pos > 0) {
                        name = ((String)name).substring(pos + 1);
                    }
                }
                if (line != -1) {
                    name = (String)name + ":" + line;
                }
            }
        }
        return name;
    }

    public static String getSourceLocation(Object node) {
        Object name = null;
        if (node instanceof LineNumberAware) {
            if (node instanceof NamedRoute) {
                node = ((NamedRoute)node).getInput();
            }
            String loc = ((LineNumberAware)node).getLocation();
            int line = ((LineNumberAware)node).getLineNumber();
            if (loc != null) {
                name = loc;
                if (line != -1) {
                    name = (String)name + ":" + line;
                }
            }
        }
        return name;
    }

    public static String stripSourceLocationLineNumber(String location) {
        int cnt = StringHelper.countChar((String)location, (char)':');
        if (cnt > 1) {
            int pos = location.lastIndexOf(58);
            return location.substring(0, pos);
        }
        return location;
    }

    public static Integer extractSourceLocationLineNumber(String location) {
        int cnt = StringHelper.countChar((String)location, (char)':');
        if (cnt > 1) {
            int pos = location.lastIndexOf(58);
            String num = location.substring(pos);
            try {
                return Integer.valueOf(num);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

