/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StartupStep;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.ContractAdvice;
import org.apache.camel.processor.RoutePipeline;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.reifier.rest.RestBindingReifier;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.Contract;
import org.apache.camel.spi.ErrorHandlerAware;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteReifier
extends ProcessorReifier<RouteDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(RouteReifier.class);
    private static final String[] RESERVED_PROPERTIES = new String[]{"id", "customId", "parent", "description", "group", "rest", "configurationId"};

    public RouteReifier(CamelContext camelContext, ProcessorDefinition<?> definition) {
        super(camelContext, (RouteDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        throw new UnsupportedOperationException("Not implemented for RouteDefinition");
    }

    public Route createRoute() {
        try {
            return this.doCreateRoute();
        }
        catch (FailedToCreateRouteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), (Throwable)e);
        }
    }

    protected Route doCreateRoute() throws Exception {
        List routePolicyList;
        RoutePolicy policy3;
        Long delayer;
        Boolean isStreamCache;
        Boolean isLogMask;
        Boolean isMessageHistory;
        Boolean isTrace;
        Endpoint endpoint = ((RouteDefinition)this.definition).getInput().getEndpoint();
        if (endpoint == null) {
            EndpointConsumerBuilder def = ((RouteDefinition)this.definition).getInput().getEndpointConsumerBuilder();
            endpoint = def != null ? def.resolve(this.camelContext) : this.resolveEndpoint(((RouteDefinition)this.definition).getInput().getEndpointUri());
        }
        String id = ((RouteDefinition)this.definition).idOrCreate(((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getNodeIdFactory());
        String desc = ((RouteDefinition)this.definition).getDescriptionText();
        Route route = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getRouteFactory().createRoute(this.camelContext, (NamedNode)this.definition, id, desc, endpoint, ((RouteDefinition)this.definition).getResource());
        route.setErrorHandlerFactory(((RouteDefinition)this.definition).getErrorHandlerFactory());
        if (((RouteDefinition)this.definition).getTrace() != null && (isTrace = this.parseBoolean(((RouteDefinition)this.definition).getTrace())) != null) {
            route.setTracing(isTrace);
            if (isTrace.booleanValue()) {
                LOG.debug("Tracing is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getMessageHistory() != null && (isMessageHistory = this.parseBoolean(((RouteDefinition)this.definition).getMessageHistory())) != null) {
            route.setMessageHistory(isMessageHistory);
            if (isMessageHistory.booleanValue()) {
                LOG.debug("Message history is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getLogMask() != null && (isLogMask = this.parseBoolean(((RouteDefinition)this.definition).getLogMask())) != null) {
            route.setLogMask(isLogMask);
            if (isLogMask.booleanValue()) {
                LOG.debug("Security mask for Logging is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getStreamCache() != null && (isStreamCache = this.parseBoolean(((RouteDefinition)this.definition).getStreamCache())) != null) {
            route.setStreamCaching(isStreamCache);
            if (isStreamCache.booleanValue()) {
                LOG.debug("StreamCaching is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getDelayer() != null && (delayer = this.parseDuration(((RouteDefinition)this.definition).getDelayer())) != null) {
            route.setDelayer(delayer);
            if (delayer > 0L) {
                LOG.debug("Delayer is enabled with: {} ms. on route: {}", (Object)delayer, (Object)((RouteDefinition)this.definition).getId());
            } else {
                LOG.debug("Delayer is disabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        Boolean isAutoStartup = this.parseBoolean(((RouteDefinition)this.definition).getAutoStartup());
        Integer startupOrder = ((RouteDefinition)this.definition).getStartupOrder();
        if (((RouteDefinition)this.definition).getShutdownRoute() != null) {
            LOG.debug("Using ShutdownRoute {} on route: {}", (Object)((RouteDefinition)this.definition).getShutdownRoute(), (Object)((RouteDefinition)this.definition).getId());
            route.setShutdownRoute(this.parse(ShutdownRoute.class, ((RouteDefinition)this.definition).getShutdownRoute()));
        }
        if (((RouteDefinition)this.definition).getShutdownRunningTask() != null) {
            LOG.debug("Using ShutdownRunningTask {} on route: {}", (Object)((RouteDefinition)this.definition).getShutdownRunningTask(), (Object)((RouteDefinition)this.definition).getId());
            route.setShutdownRunningTask(this.parse(ShutdownRunningTask.class, ((RouteDefinition)this.definition).getShutdownRunningTask()));
        }
        route.getInterceptStrategies().addAll(((RouteDefinition)this.definition).getInterceptStrategies());
        for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
            strategy.onRouteContextCreate(route);
        }
        if (!this.hasOutputs(((RouteDefinition)this.definition).getOutputs(), true)) {
            String at = ((RouteDefinition)this.definition).getInput().toString();
            IllegalArgumentException cause = new IllegalArgumentException("Route " + ((RouteDefinition)this.definition).getId() + " has no output processors. You need to add outputs to the route such as to(\"log:foo\").");
            throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), at, (Throwable)cause);
        }
        ArrayList list = new ArrayList(((RouteDefinition)this.definition).getOutputs());
        for (ProcessorDefinition output : list) {
            try {
                ProcessorReifier<ProcessorDefinition<?>> reifier = ProcessorReifier.reifier(route, output);
                String outputId = output.idOrCreate(((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getNodeIdFactory());
                String eip = reifier.getClass().getSimpleName().replace("Reifier", "");
                StartupStep step = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getStartupStepRecorder().beginStep(ProcessorReifier.class, outputId, "Create " + (String)eip + " Processor");
                reifier.addRoutes();
                ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getStartupStepRecorder().endStep(step);
            }
            catch (Exception e) {
                throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), output.toString(), (Throwable)e);
            }
        }
        List eventDrivenProcessors = route.getEventDrivenProcessors();
        if (eventDrivenProcessors.isEmpty()) {
            return null;
        }
        Map<String, Object> routeProperties = this.computeRouteProperties();
        RoutePipeline target = new RoutePipeline(this.camelContext, (Collection)eventDrivenProcessors);
        target.setRouteId(id);
        InternalProcessor internal = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getInternalProcessorFactory().addUnitOfWorkProcessorAdvice(this.camelContext, (Processor)target, route);
        if (((RouteDefinition)this.definition).getRoutePolicies() != null && !((RouteDefinition)this.definition).getRoutePolicies().isEmpty()) {
            for (RoutePolicy policy2 : ((RouteDefinition)this.definition).getRoutePolicies()) {
                LOG.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy2, (Object)((RouteDefinition)this.definition).getId());
                route.getRoutePolicyList().add(policy2);
            }
        }
        if (((RouteDefinition)this.definition).getRoutePolicyRef() != null) {
            StringTokenizer policyTokens = new StringTokenizer(((RouteDefinition)this.definition).getRoutePolicyRef(), ",");
            while (policyTokens.hasMoreTokens()) {
                String ref = policyTokens.nextToken().trim();
                policy3 = this.mandatoryLookup(ref, RoutePolicy.class);
                LOG.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy3, (Object)((RouteDefinition)this.definition).getId());
                route.getRoutePolicyList().add(policy3);
            }
        }
        if (this.camelContext.getRoutePolicyFactories() != null) {
            for (RoutePolicyFactory factory : this.camelContext.getRoutePolicyFactories()) {
                policy3 = factory.createRoutePolicy(this.camelContext, ((RouteDefinition)this.definition).getId(), (NamedNode)this.definition);
                if (policy3 == null) continue;
                LOG.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy3, (Object)((RouteDefinition)this.definition).getId());
                route.getRoutePolicyList().add(policy3);
            }
        }
        if ((routePolicyList = route.getRoutePolicyList()) != null && !routePolicyList.isEmpty()) {
            for (RoutePolicy policy3 : routePolicyList) {
                if (this.camelContext.hasService((Object)policy3)) continue;
                try {
                    this.camelContext.addService((Object)policy3);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
            internal.addRoutePolicyAdvice(routePolicyList);
        }
        internal.addRouteInflightRepositoryAdvice(this.camelContext.getInflightRepository(), route.getRouteId());
        ManagementInterceptStrategy managementInterceptStrategy = route.getManagementInterceptStrategy();
        if (managementInterceptStrategy != null) {
            internal.addManagementInterceptStrategy(managementInterceptStrategy.createProcessor("route"));
        }
        internal.addRouteLifecycleAdvice();
        if (((RouteDefinition)this.definition).getRestBindingDefinition() != null) {
            try {
                internal.addAdvice((CamelInternalProcessorAdvice)new RestBindingReifier(route, ((RouteDefinition)this.definition).getRestBindingDefinition()).createRestBindingAdvice());
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        if (((RouteDefinition)this.definition).getInputType() != null || ((RouteDefinition)this.definition).getOutputType() != null) {
            Contract contract = new Contract();
            if (((RouteDefinition)this.definition).getInputType() != null) {
                contract.setInputType(this.parseString(((RouteDefinition)this.definition).getInputType().getUrn()));
                contract.setValidateInput(this.parseBoolean(((RouteDefinition)this.definition).getInputType().getValidate(), false));
            }
            if (((RouteDefinition)this.definition).getOutputType() != null) {
                contract.setOutputType(this.parseString(((RouteDefinition)this.definition).getOutputType().getUrn()));
                contract.setValidateOutput(this.parseBoolean(((RouteDefinition)this.definition).getOutputType().getValidate(), false));
            }
            internal.addAdvice((CamelInternalProcessorAdvice)new ContractAdvice(contract));
            this.camelContext.setUseDataType(Boolean.valueOf(true));
        }
        route.setProcessor((Processor)internal);
        route.getProperties().putAll(routeProperties);
        route.setStartupOrder(startupOrder);
        if (isAutoStartup != null) {
            LOG.debug("Using AutoStartup {} on route: {}", (Object)isAutoStartup, (Object)((RouteDefinition)this.definition).getId());
            route.setAutoStartup(isAutoStartup);
        }
        internal.setRouteOnAdvices(route);
        if (routePolicyList != null && !routePolicyList.isEmpty()) {
            for (RoutePolicy policy4 : routePolicyList) {
                policy4.onInit(route);
            }
        }
        ErrorHandlerFactory builder = route.getErrorHandlerFactory();
        Processor errorHandler = ((ModelCamelContext)this.camelContext.adapt(ModelCamelContext.class)).getModelReifierFactory().createErrorHandler(route, builder, null);
        this.prepareErrorHandlerAware(route, errorHandler);
        if (this.camelContext.getStatus().ordinal() < ServiceStatus.Started.ordinal()) {
            ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).addBootstrap(() -> ((Route)route).clearRouteModel());
        }
        return route;
    }

    private void prepareErrorHandlerAware(Route route, Processor errorHandler) {
        List processors = route.filter("*");
        for (Processor p : processors) {
            if (!(p instanceof ErrorHandlerAware)) continue;
            ((ErrorHandlerAware)p).setErrorHandler(errorHandler);
        }
    }

    protected Map<String, Object> computeRouteProperties() {
        List properties;
        HashMap<String, Object> routeProperties = new HashMap<String, Object>();
        routeProperties.put("id", ((RouteDefinition)this.definition).getId());
        routeProperties.put("customId", Boolean.toString(((RouteDefinition)this.definition).hasCustomIdAssigned()));
        routeProperties.put("parent", Integer.toHexString(((RouteDefinition)this.definition).hashCode()));
        routeProperties.put("description", ((RouteDefinition)this.definition).getDescriptionText());
        if (((RouteDefinition)this.definition).getGroup() != null) {
            routeProperties.put("group", ((RouteDefinition)this.definition).getGroup());
        }
        String rest = Boolean.toString(((RouteDefinition)this.definition).isRest() != null && ((RouteDefinition)this.definition).isRest() != false);
        routeProperties.put("rest", rest);
        String template = Boolean.toString(((RouteDefinition)this.definition).isTemplate() != null && ((RouteDefinition)this.definition).isTemplate() != false);
        routeProperties.put("template", template);
        if (((RouteDefinition)this.definition).getAppliedRouteConfigurationIds() != null) {
            routeProperties.put("configurationId", String.join((CharSequence)",", ((RouteDefinition)this.definition).getAppliedRouteConfigurationIds()));
        }
        if ((properties = ((RouteDefinition)this.definition).getRouteProperties()) != null) {
            for (PropertyDefinition prop : properties) {
                try {
                    String key = this.parseString(prop.getKey());
                    String val = this.parseString(prop.getValue());
                    for (String property : RESERVED_PROPERTIES) {
                        if (!property.equalsIgnoreCase(key)) continue;
                        throw new IllegalArgumentException("Cannot set route property " + property + " as it is a reserved property");
                    }
                    routeProperties.put(key, val);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
        }
        return routeProperties;
    }
}

